import { Selector } from '../../../../utils';

export abstract class BaseForm<Value> {
   protected abstract wrapper: Selector;

   protected displayName: string;

   public abstract fields;

   public set(value: Value) {
      this.apply(value, 'set');
   }

   public check(value: Value, ...params) {
      this.apply(value, 'check', ...params);
   }

   protected apply(value: Value, methodName: string, ...params) {
      for (let [field, fieldValue] of Object.entries(value)) {
         if (this.fields[field]?.[methodName]) {
            this.fields[field][methodName](fieldValue, ...params);
         } else {
            throw new Error(`Form field '${this.displayName}.${field}' has no method name '${methodName}'`);
         }
      }
   }
}
