import { dataE2E, dataTest, fieldControl, sel } from '../../../../../utils';

import { BaseFormField, TextInputField } from '../../../../components';

import { BaseForm } from '../BaseForm';
import { BoxDockerFormValue, BoxDockerForm } from './fields/BoxDockerForm';
import { BoxLayerAction, BoxLayersForm } from './fields/BoxLayersForm';
import { BoxStaticResourceAction, BoxStaticResourcesForm } from './fields/BoxStaticResourcesForm';

type BoxField = 'id' | 'docker' | 'staticResources' | 'layers';

type BoxFieldValue = Partial<{
   id: string;
   docker: BoxDockerFormValue;
   layers: BoxLayerAction[];
   staticResources: BoxStaticResourceAction[];
}>;

export class BoxForm extends BaseForm<BoxFieldValue> {
   displayName = 'BoxForm';

   wrapper = dataE2E('SubForm:box');

   constructor(private readonly: boolean) {
      super();
   }

   public check(value: BoxFieldValue) {
      this.apply(value, 'check', { readonly: this.readonly });
   }

   // private buttons = {
   //    clone: sel(this.wrapper, dataE2E('SubForm:CloneButton')),
   //    remove: sel(this.wrapper, dataE2E('SubForm:RemoveButton')),
   // };

   // public clone() {
   //    cy.get(this.buttons.clone).scrollIntoView().should('be.visible').click();
   // }

   // public remove() {
   //    cy.get(this.buttons.remove).scrollIntoView().should('be.visible').click();
   // }

   public fields: Record<BoxField, BaseFormField> = {
      id: new TextInputField(sel(this.wrapper, fieldControl('id'))),
      docker: new BoxDockerForm(),
      layers: new BoxLayersForm(sel(this.wrapper, dataTest('Box:Layers'))),
      staticResources: new BoxStaticResourcesForm(sel(this.wrapper, dataTest('Box:StaticResources'))),
   };
}
