import { dataE2E, sel } from '../../../../../../utils';

import {
   BaseFormField,
   EnabledSwitcherField,
   EnabledSwitcherFieldValue,
   TextInputField,
   TextInputFieldValue,
} from '../../../../../components';

import { BaseForm } from '../../BaseForm';

type BoxDockerField = 'enabled' | 'name' | 'tag';

export type BoxDockerFormValue = Partial<{
   enabled: EnabledSwitcherFieldValue;
   name: TextInputFieldValue;
   tag: TextInputFieldValue;
}>;

export class BoxDockerForm extends BaseForm<BoxDockerFormValue> {
   displayName = 'BoxDockerForm';

   wrapper = dataE2E('Box:Docker');

   public fields: Record<BoxDockerField, BaseFormField> = {
      enabled: new EnabledSwitcherField(sel(this.wrapper, dataE2E('Docker:Enabled'))),
      name: new TextInputField(sel(this.wrapper, dataE2E('Docker:Name'))),
      tag: new TextInputField(sel(this.wrapper, dataE2E('Docker:Tag'))),
   };
}
