import { dataQa, dataTest, sel } from '../../../../../../utils';

import { YCSelectField, YCSelectFieldValue } from '../../../../../components';

export interface BoxLayerItem {
   id: YCSelectFieldValue;
}
export interface BoxLayerAction {
   order: number; // table row

   add?: boolean;
   remove?: boolean;
   item?: BoxLayerItem;
}

export class BoxLayersForm {
   constructor(private selector: string) {}

   private buttons = {
      add: sel(this.selector, dataQa('Layers:AddLayer')),
   };

   private add() {
      cy.get(this.buttons.add).scrollIntoView().should('be.visible').click();
   }

   public set(value: BoxLayerAction[]) {
      this.apply(value, 'set');
   }

   public check(value: BoxLayerAction[], ...params) {
      this.apply(value, 'check', ...params);
   }

   protected apply(value: BoxLayerAction[], methodName: string, ...params) {
      value.forEach(action => {
         cy.log(`Box layer ${action.order} settings`);

         if (action.add) {
            cy.log(`Add new layer`);

            this.add();
         }

         if (action.item?.id) {
            const idField = new YCSelectField(sel(dataTest(`Layer:${action.order}:Id`)));

            idField[methodName](action.item.id, ...params);
         }

         if (action.remove) {
            cy.log(`Remove layer`);

            cy.get(sel(this.selector, dataTest(`Layer:${action.order}:Buttons`), dataQa('ButtonRemove')))
               .should('be.visible')
               .click();
         }
      });
   }
}
