import { dataQa, dataTest, sel } from '../../../../../../utils';

import { TextInputField, TextInputFieldValue, YCSelectField, YCSelectFieldValue } from '../../../../../components';

export interface BoxStaticResourceItem {
   id?: YCSelectFieldValue;
   mountPoint?: TextInputFieldValue;
}

export interface BoxStaticResourceAction {
   order: number; // table row

   add?: boolean;
   remove?: boolean;
   item?: BoxStaticResourceItem;
}

export class BoxStaticResourcesForm {
   constructor(private selector: string) {}

   private buttons = {
      add: sel(this.selector, dataQa('StaticResources:AddStaticResource')),
   };

   private add() {
      cy.get(this.buttons.add).scrollIntoView().should('be.visible').click();
   }

   public set(value: BoxStaticResourceAction[]) {
      this.apply(value, 'set');
   }

   public check(value: BoxStaticResourceAction[], ...params) {
      this.apply(value, 'check', ...params);
   }

   protected apply(value: BoxStaticResourceAction[], methodName: string, ...params) {
      value.forEach(action => {
         cy.log(`Box static resource ${action.order} settings`);

         if (action.add) {
            cy.log(`Add new static resource`);

            this.add();
         }

         if (action.item?.id) {
            const idField = new YCSelectField(sel(dataTest(`StaticResource:${action.order}:Id`)));

            idField[methodName](action.item.id, ...params);
         }

         if (action.item?.mountPoint) {
            const mountPointField = new TextInputField(dataTest(`StaticResource:${action.order}:MountPoint`));

            mountPointField[methodName](action.item.mountPoint, ...params);
         }

         if (action.remove) {
            cy.log(`Remove static resource`);

            cy.get(sel(this.selector, dataTest(`StaticResource:${action.order}:Buttons`), dataQa('ButtonRemove')))
               .should('be.visible')
               .click();
         }
      });
   }
}
