import { dataE2E, dataTest, fieldControl, sel } from '../../../../../utils';

import {
   BaseFormField,
   EnumField,
   TextInputField,
   TextInputFieldValue,
   YCSuggestField,
   YCSuggestFieldValue,
} from '../../../../components';

import { BaseForm } from '../BaseForm';
import { DiskLayerAction, DiskLayersForm } from './fields/DiskLayersForm';
import { LocationCards, LocationCardsValue } from './fields/LocationCards';
import { DiskStaticResourceAction, DiskStaticResourcesForm } from './fields/DiskStaticResourcesForm';

type DeployUnitField =
   | 'id'
   | 'type'
   | 'disruptionBudget'
   | 'network'
   | 'networkBandwidthGuarantee'
   | 'cpu'
   | 'ram'
   | 'locations'
   | 'layers'
   | 'staticResources';

type DeployUnitFormValue = Partial<{
   id: TextInputFieldValue;
   type: 'replica_set' | 'multi_cluster_replica_set';
   disruptionBudget: TextInputFieldValue;
   network: YCSuggestFieldValue;
   networkBandwidthGuarantee: TextInputFieldValue;
   cpu: TextInputFieldValue;
   ram: TextInputFieldValue;
   locations: LocationCardsValue;
   layers: DiskLayerAction[];
   staticResources: DiskStaticResourceAction[];
}>;

export class DeployUnitForm extends BaseForm<DeployUnitFormValue> {
   displayName = 'DeployUnitForm';

   wrapper = dataE2E('SubForm:deployUnit');

   constructor(private readonly: boolean) {
      super();
   }

   public check(value: DeployUnitFormValue) {
      this.apply(value, 'check', { readonly: this.readonly });
   }

   // private buttons = {
   //    clone: sel(this.wrapper, dataE2E('SubForm:CloneButton')),
   //    remove: sel(this.wrapper, dataE2E('SubForm:RemoveButton')),
   // };

   // public clone() {
   //    cy.get(this.buttons.clone).scrollIntoView().should('be.visible').click();
   // }

   // public remove() {
   //    cy.get(this.buttons.remove).scrollIntoView().should('be.visible').click();
   // }

   public fields: Record<DeployUnitField, BaseFormField> = {
      id: new TextInputField(sel(this.wrapper, fieldControl('id'))),
      type: new EnumField<'replica_set' | 'multi_cluster_replica_set'>(sel(this.wrapper, fieldControl('type'))),
      disruptionBudget: new TextInputField(sel(this.wrapper, fieldControl('disruptionBudget'))),
      network: new YCSuggestField(sel(this.wrapper, fieldControl('networkDefaults.networkId'))),
      networkBandwidthGuarantee: new TextInputField(sel(this.wrapper, fieldControl('networkBandwidth.guarantee'))),
      cpu: new TextInputField(sel(this.wrapper, fieldControl('cpu'))),
      ram: new TextInputField(sel(this.wrapper, fieldControl('ram'))),
      locations: new LocationCards(sel(this.wrapper, fieldControl('locations', ''))),
      layers: new DiskLayersForm(sel(this.wrapper, dataTest('Disk:Layers'))),
      staticResources: new DiskStaticResourcesForm(sel(this.wrapper, dataTest('Disk:StaticResources'))),
   };
}
