import { dataE2E, dataQa, dataTest, sel } from '../../../../../../utils';

import { TextInputField, TextInputFieldValue, YCRadioField } from '../../../../../components';

export type DiskLayerItem = Partial<{
   id: TextInputFieldValue;
   type: string;
   url: TextInputFieldValue;
   checksum: TextInputFieldValue;
}>;

export type Action = Partial<{
   add: boolean;
   remove: boolean;
   restore: boolean;
   item: DiskLayerItem;
}>;

export interface DiskLayerAction extends Action {
   order: number;
}

export class DiskLayersForm {
   constructor(private selector: string) {}

   private buttons = {
      add: sel(this.selector, dataQa('Layers:AddLayer')),
   };

   private cardForm = (order: number) => {
      const card = sel(this.selector, dataTest(`Layer:${order}`));
      const n = order - 1;

      return {
         fields: {
            idField: new TextInputField(sel(card, dataQa(`disks.[0].layers[${n}].id:FieldLayout`))),
            typeField: new YCRadioField(sel(card, dataQa(`disks.[0].layers[${n}].layerType:FieldLayout`))),
            urlField: new TextInputField(sel(card, dataQa(`disks.[0].layers[${n}].url:FieldLayout`))),
            checksumField: new TextInputField(sel(card, dataQa(`disks.[0].layers[${n}].checksum:FieldLayout`))),

            // layerSourceFileStoragePolicyField: new TextInputField(
            //    sel(card, dataQa(`disks.[0].layers[${n}].layerSourceFileStoragePolicy:FieldLayout`)),
            // ),
         },
         buttons: {
            remove: sel(card, dataE2E('Layer:Remove')),
            restore: sel(card, dataE2E('Layer:Restore')),
         },
      };
   };

   private add() {
      cy.log(`Add new layer`);
      cy.get(this.buttons.add).scrollIntoView().should('be.visible').click();
   }

   public set(value: DiskLayerAction[]) {
      this.apply(value, 'set');
   }

   public check(value: DiskLayerAction[], ...params) {
      this.apply(value, 'check', ...params);
   }

   protected apply(value: DiskLayerAction[], methodName: string, ...params) {
      value.forEach(action => {
         cy.log(`Disk layer ${action.order} settings`);

         const { fields, buttons } = this.cardForm(action.order);

         if (action.add) {
            this.add();
         }

         if (action.item) {
            if (action.item.id) {
               fields.idField[methodName](action.item.id, ...params);
            }

            if (action.item.type) {
               fields.typeField[methodName](action.item.type, ...params);
            }

            if (action.item.url) {
               fields.urlField[methodName](action.item.url, ...params);
            }

            if (action.item.checksum) {
               fields.checksumField[methodName](action.item.checksum, ...params);
            }
         }

         if (action.remove) {
            cy.log(`Remove layer`);
            cy.get(buttons.remove).should('be.visible').click();
         }

         if (action.restore) {
            cy.log(`Restore static resource`);
            cy.get(buttons.restore).should('be.visible').click();
         }
      });
   }
}
