import { dataQa, sel, TIMEOUTS } from '../../../../../../utils';

import { CheckboxField, TextInputField } from '../../../../../components';

export interface LocationItem {
   enabled: boolean;
   id: string;
   podCount: number;
}

export type LocationCardsValue = Partial<LocationItem>[];

export class LocationCards {
   constructor(private selector: string) {}

   public check(v: LocationCardsValue) {
      // TODO
      throw new Error('TODO LocationCards check');
   }

   public set(v: LocationCardsValue) {
      for (const cluster of v) {
         cy.log(`Location card "${cluster.id}"`);
         const name = `locations[${cluster.id}]`;
         const card = sel(this.selector, dataQa(`LocationCard:${cluster.id.toUpperCase()}`));

         cy.get(card, { timeout: TIMEOUTS.immediately }).within(() => {
            const getFieldLabel = (fieldName: string) => `label[for="${name}.${fieldName}"]`;

            const enabledCheckbox = new CheckboxField('header .yc-checkbox');
            if (cluster.enabled !== undefined) {
               cy.log('Set enabled', cluster.enabled);
               enabledCheckbox.set(cluster.enabled);
            }

            enabledCheckbox.getInput().then(($checkbox: JQuery<HTMLInputElement>) => {
               const isChecked: boolean = $checkbox.prop('checked');
               if (!isChecked) {
                  return;
               }

               if (cluster.podCount !== undefined) {
                  const control = new TextInputField(getFieldLabel('podCount') + ' + div .yc-text-input');
                  cy.log('Set podCount', cluster.enabled);
                  control.set(String(cluster.podCount));
               }
            });
         });

         // const elements = {
         //    enabled: new Checkbox(getFieldLabel('enabled').parent('header'), 'LocationCard:enabled'),
         //    disruptionBudget: new TextInputField(getFieldLabel('disruptionBudget').nextSibling('div')),
         //    maintenanceBudget: new TextInputField(getFieldLabel('maxTolerableDowntimePods').nextSibling('div')),
         //    maxMaintenanceDuration: new TextInputField(getFieldLabel('maxTolerableDowntimeSeconds').nextSibling('div')),
         //    antiaffinity: {
         //       perNode: {
         //          checkbox: new Checkbox(card.find(getDataTestSelector('Antiaffinity:PerNode'))),
         //          maxPods: new TextInputField(
         //             card.find(getDataTestSelector('Antiaffinity:PerNode')).find('.textinput'),
         //          ),
         //       },
         //       perRack: {
         //          checkbox: new Checkbox(card.find(getDataTestSelector('Antiaffinity:PerRack'))),
         //          maxPods: new TextInputField(
         //             card.find(getDataTestSelector('Antiaffinity:PerRack')).find('.textinput'),
         //          ),
         //       },
         //    },
         // };
      }
   }
}
