import { dataE2E, fieldControl, sel } from '../../../../../utils';

import {
   BaseFormField,
   EnabledSwitcherField,
   EnabledSwitcherFieldValue,
   TextInputField,
   TextInputFieldValue,
   YCSelectField,
   YCSelectFieldValue,
} from '../../../../components';

import { BaseForm } from '../BaseForm';
import { InfraForm, InfraFieldValue } from './fields/InfraForm';

type StageField = 'id' | 'project' | 'infra' | 'sox' | 'abc';

export type StageFormValue = Partial<{
   'id': TextInputFieldValue;
   'project': YCSelectFieldValue;
   'infra': InfraFieldValue;
   'sox': EnabledSwitcherFieldValue;
   'abc': TextInputFieldValue;
}>;

export class StageForm extends BaseForm<StageFormValue> {
   displayName = 'StageForm';

   wrapper = dataE2E('SubForm:stage');

   constructor(private readonly: boolean) {
      super();
   }

   public check(value: StageFormValue) {
      this.apply(value, 'check', { readonly: this.readonly });
   }

   public fields: Record<StageField, BaseFormField> = {
      id: new TextInputField(sel(this.wrapper, fieldControl('id'))),
      project: new YCSelectField(sel(this.wrapper, fieldControl('project')), { showSearch: true }),
      abc: new TextInputField(sel(this.wrapper, fieldControl('project.accountId'))),
      sox: new EnabledSwitcherField(sel(this.wrapper, fieldControl('soxService'))),
      infra: new InfraForm(),

      // TODO: tags
   };
}
