import { dataE2E, sel } from '../../../../../../utils';

import { YCSelectField } from '../../../../../components';
import { BaseForm } from '../../BaseForm';

type InfraField = 'service' | 'environment';

export type InfraFieldValue = Record<InfraField, string>;

export class InfraForm extends BaseForm<InfraFieldValue> {
   displayName = 'InfraSubForm';

   wrapper = dataE2E('Infra');

   public fields = {
      service: new YCSelectField(sel(this.wrapper, dataE2E('Infra:Service')), { showSearch: true }),
      environment: new YCSelectField(sel(this.wrapper, dataE2E('Infra:Environment')), { showSearch: true }),
   };
}
