import { dataE2E, fieldControl, sel } from '../../../../../utils';

import {
   BaseFormField,
   EnabledSwitcherField,
   EnabledSwitcherFieldValue,
   TextInputField,
   TextInputFieldValue,
} from '../../../../components';

import { BaseForm } from '../BaseForm';
import { WorkloadCommandsFormValue, WorkloadCommandsForm } from './fields/WorkloadCommandsForm';

type WorkloadField = 'id' | 'logs' | 'commands';

type WorkloadFormValue = Partial<{
   id: TextInputFieldValue;
   logs: EnabledSwitcherFieldValue;
   commands: WorkloadCommandsFormValue[];
}>;

export class WorkloadForm extends BaseForm<WorkloadFormValue> {
   displayName = 'WorkloadForm';

   wrapper = dataE2E('SubForm:workload');

   constructor(private readonly: boolean) {
      super();
   }

   public check(value: WorkloadFormValue) {
      this.apply(value, 'check', { readonly: this.readonly });
   }

   // private buttons = {
   //    clone: sel(this.wrapper, dataE2E('SubForm:CloneButton')),
   //    remove: sel(this.wrapper, dataE2E('SubForm:RemoveButton')),
   // };

   // public clone() {
   //    cy.get(this.buttons.clone).scrollIntoView().should('be.visible').click();
   // }

   // public remove() {
   //    cy.get(this.buttons.remove).scrollIntoView().should('be.visible').click();
   // }

   public fields: Record<WorkloadField, BaseFormField> = {
      id: new TextInputField(sel(this.wrapper, fieldControl('id', '.textinput'))),
      logs: new EnabledSwitcherField(sel(this.wrapper, fieldControl('logs'))),
      commands: new WorkloadCommandsForm(sel(this.wrapper, fieldControl('commands'))),
   };
}
