import { dataE2E, dataQa, dataTest, sel } from 'utils';

import { CheckboxField, TextAreaField, TextInputField, YCRadioField } from 'page_objects/components';

export enum ProbeMode {
   EXEC = 'exec',
   TCP = 'tcp',
   HTTP = 'http',
}

export type Exec = Partial<{
   command: string;
   // TODO: advanced
}>;

export type Tcp = Partial<{
   port: string;
   // TODO: advanced
}>;

export type Http = Partial<{
   path: string;
   port: string;
   answer: {
      expected?: string;
      any?: boolean;
   };
   // TODO: advanced
}>;

export type Probe = Partial<{
   mode: ProbeMode;
   exec: Exec;
   tcp: Tcp;
   http: Http;
}>;

export type Stop = Partial<{
   maxTries: string;
   mode: ProbeMode.EXEC | ProbeMode.HTTP;
   exec: Exec;
   // tcp: ProbeTcp; нет
   http: Http;
   unixSignal: string;
}>;

export type Destroy = Partial<{
   maxTries: string;
   mode: ProbeMode.EXEC | ProbeMode.HTTP;
   exec: Exec;
   // tcp: ProbeTcp; нет
   http: Http;
}>;

type Access = Partial<{
   user: string;
   group: string;
}>;

// type Limits = Partial<{
//    cpu: string; // TODO units
//    ram: string; // TODO units
// }>;

// type RetryPolicy = Partial<{
//    ...
// }>;

type CommandAdvanced = Partial<{
   hide: boolean;
   show: boolean;
   access: Access;
   // limits: Limits;
   // retryPolicy: RetryPolicy;
}>;

// type ProbeAdvanced = Partial<{
//    hide: boolean;
//    show: boolean;
//    // retryPolicy: RetryPolicy;
// }>;

type Start = Partial<{
   command: string;
   advanced: CommandAdvanced;
}>;

interface Init {
   order: number;

   add?: boolean;
   command?: string;
   remove?: boolean;
}

export type WorkloadCommandsFormValue = Partial<{
   start: Start;
   init: Init[];
   liveness: Probe;
   readiness: Probe;
   stop: Stop;
   destroy: Destroy;
}>;

export class WorkloadCommandsForm {
   constructor(private selector: string) {}

   private buttons = {
      advancedSettings: {
         hideButton: sel(this.selector, dataQa('FormAdvancedSection:HideToggleButton')),
         showButton: sel(this.selector, dataQa('FormAdvancedSection:ShowToggleButton')),
      },

      addInitCommand: sel(this.selector, dataQa('commands.init.buttons.add')),
      removeInitCommand: (i: number = 1) => sel(this.selector, dataTest(`commands.init_${i - 1}.remove`)),
   };

   private tabs = {
      init: (i: number = 1) => sel(this.selector, dataTest(`commands.init_${i - 1}.tab`)),
      start: sel(this.selector, dataTest('commands.start.tab')),
      liveness: sel(this.selector, dataTest('commands.liveness.tab')),
      readiness: sel(this.selector, dataTest('commands.readiness.tab')),
      stop: sel(this.selector, dataTest('commands.stop.tab')),
      destroy: sel(this.selector, dataTest('commands.destroy.tab')),
   };

   private fields = {
      start: new TextAreaField(sel(this.selector, dataQa('commands.start.command:FieldLayout'))),
      init: (i: number = 1) =>
         new TextAreaField(sel(this.selector, dataQa(`commands.init[${i - 1}].command:FieldLayout`))),
   };

   public set(value: WorkloadCommandsFormValue[]) {
      this.apply(value, 'set');
   }

   public check(value: WorkloadCommandsFormValue[], ...params) {
      this.apply(value, 'check', ...params);
   }

   protected apply(value: WorkloadCommandsFormValue[], methodName: string, ...params) {
      value.forEach(action => {
         if (action.start) {
            cy.get(this.tabs.start).click();

            if (action.start.command !== undefined) {
               this.fields.start[methodName](action.start.command, ...params);
            }

            // TODO: сделать для всех команд
            if (action.start.advanced) {
               if (action.start.advanced.show) {
                  cy.get(this.buttons.advancedSettings.showButton)
                     .should('be.visible')
                     .should('not.be.disabled')
                     .click();
               }

               if (action.start.advanced.access) {
                  if (action.start.advanced.access.user) {
                     const field = new TextInputField(sel(this.selector, dataTest('AdvancedSettings:Access:User')));

                     field[methodName](action.start.advanced.access.user, ...params);
                  }

                  if (action.start.advanced.access.group) {
                     const field = new TextInputField(sel(this.selector, dataTest('AdvancedSettings:Access:Group')));

                     field[methodName](action.start.advanced.access.group, ...params);
                  }
               }

               if (action.start.advanced.hide) {
                  cy.get(this.buttons.advancedSettings.hideButton)
                     .should('be.visible')
                     .should('not.be.disabled')
                     .click();
               }
            }
         }

         if (action.init) {
            action.init.forEach(init => {
               if (init.add) {
                  cy.get(this.buttons.addInitCommand).click();
               }

               cy.get(this.tabs.init(init.order)).click();

               if (init.command !== undefined) {
                  this.fields.init(init.order)[methodName](init.command, ...params);
               }

               if (init.remove) {
                  cy.get(this.buttons.removeInitCommand(init.order))
                     .should('be.visible')
                     .should('not.be.disabled')
                     .click();
               }
            });
         }

         ['liveness', 'readiness', 'stop', 'destroy'].forEach(probe => {
            if (action[probe]) {
               cy.get(this.tabs[probe]).click();
               cy.get(sel(this.selector, dataE2E(`FormTabContent:${probe}`))).should('be.visible');
               cy.get(sel(this.selector, dataTest(`commands.${probe}`))).should('be.visible');

               if (action[probe].mode) {
                  const field = new YCRadioField(sel(this.selector, dataQa(`commands.${probe}.mode:FieldLayout`)));

                  field[methodName](action[probe].mode, ...params);
               }

               if (action[probe].exec) {
                  if (action[probe].exec.command !== undefined) {
                     const field = new TextAreaField(
                        sel(this.selector, dataQa(`commands.${probe}.exec.command:FieldLayout`)),
                     );

                     field[methodName](action[probe].exec.command, ...params);
                  }

                  // TODO: advanced
               }

               if (action[probe].tcp) {
                  if (action[probe].tcp.port !== undefined) {
                     const field = new TextInputField(
                        sel(this.selector, dataQa(`commands.${probe}.tcp.port:FieldLayout`)),
                     );

                     field[methodName](action[probe].tcp.port, ...params);
                  }

                  // TODO: advanced
               }

               if (action[probe].http) {
                  if (action[probe].http.path !== undefined) {
                     const field = new TextInputField(
                        sel(this.selector, dataQa(`commands.${probe}.http.path:FieldLayout`)),
                     );

                     field[methodName](action[probe].http.path, ...params);
                  }

                  if (action[probe].http.port !== undefined) {
                     const field = new TextInputField(
                        sel(this.selector, dataQa(`commands.${probe}.http.port:FieldLayout`)),
                     );

                     field[methodName](action[probe].http.port, ...params);
                  }

                  if (action[probe].http.answer) {
                     if (action[probe].http.answer.expected !== undefined) {
                        const field = new TextAreaField(
                           sel(this.selector, dataQa(`commands.${probe}.http.expectedAnswer:FieldLayout`)),
                        );

                        field[methodName](action[probe].http.answer.expected, ...params);
                     }

                     if (action[probe].http.answer.any !== undefined) {
                        const field = new CheckboxField(
                           sel(this.selector, dataQa(`commands.${probe}.http.any:FieldLayout`)),
                        );

                        field[methodName](action[probe].http.answer.any, ...params);
                     }
                  }

                  // TODO: advanced
               }

               if (action[probe].maxTries !== undefined) {
                  const field = new TextInputField(
                     sel(this.selector, dataQa(`commands.${probe}.maxTries:FieldLayout`)),
                  );

                  field[methodName](action[probe].maxTries, ...params);
               }
            }
         });

         // cy.wait(1000);
      });
   }
}
