import * as express from 'express';
import * as fs from 'fs';
import { createProxyMiddleware } from 'http-proxy-middleware';
import * as https from 'https';
import { normalizeBranchName } from './utils/normalizeBranchName';

import { readStdout } from './utils/readStdout';

const PORT = 9000;
const S3_DIR = `http://infracloudui-cdn.s3.mds.yandex.net/deploy`;

const BRANCH = normalizeBranchName(process.env.TRENDBOX_BRANCH ?? readStdout('git branch --show-current'));
const UI_URL = `${S3_DIR}/${BRANCH}/ui`;
const SB_URL = `${S3_DIR}/${BRANCH}/storybook`;

const logLevel = 'info'; // 'debug';
const app = express();

app.all('/_storybook', (req, res) => {
   res.redirect('/_storybook/index.html');
});

app.all(
   '/_storybook*',
   createProxyMiddleware({
      changeOrigin: true,
      logLevel,
      pathRewrite: path => path.replace('_storybook/', ''),
      target: SB_URL,
   }),
);

app.all(
   '/*',
   createProxyMiddleware({
      changeOrigin: true,
      logLevel,
      pathRewrite: path => (path.match(/\.(json|js|css|png|map|svg|woff2|woff|eot|ttf)$/) ? path : '/index.html'),
      target: UI_URL,
   }),
);

// HTTPS server
const certificate = fs.readFileSync('../configs/localhost.yandex-team.ru.crt', 'utf8');
const privateKey = fs.readFileSync('../configs/localhost.yandex-team.ru.key', 'utf8');

const credentials = { key: privateKey, cert: certificate };
const httpsServer = https.createServer(credentials, app);

httpsServer.listen(PORT, () => console.log(`Server listening on https://localhost.yandex-team.ru:${PORT}`));
