Cypress.Commands.add('login', (login: string, passwd: string) => {
   cy.request({
      body: { retpath: encodeURIComponent(Cypress.env('baseUrl')), login, passwd },
      followRedirect: false,
      form: true,
      log: true,
      method: 'POST',
      url: Cypress.env('passport'),
   });
});

let authorized = false;

Cypress.Commands.add('loginRobot', () => {
   if (authorized) {
      return;
   }

   cy.login(Cypress.env('ROBOT_LOGIN'), Cypress.env('ROBOT_PASSWORD'));
   authorized = true;
});

Cypress.Commands.add('envConfig', () => {
   cy.window().then(w => w.CONFIG);
});

/**
 * @deprecated возможно стоит объединить с loginRobot в одну команду (init?)
 */
Cypress.Commands.add('emptyPage', () => {
   cy.visit('/about', {
      onBeforeLoad: contentWindow => {
         contentWindow.localStorage.setItem('dev.reloadWarning.enable', 'false');
         contentWindow.localStorage.setItem('promo.visible.du.tabs.disks', 'false');
         contentWindow.localStorage.setItem('promo.visible.du.tabs.disks.resources', 'false');
         contentWindow.localStorage.setItem('promo.visible.box.tabs.resources', 'false');
      },
   });
});

Cypress.Commands.add('locationUrl', () => {
   cy.location().then(l => l.href.replace(l.origin, ''));
});
