// in cypress/support/index.d.ts
// load type definitions that come with Cypress module
/// <reference types="cypress" />

interface TestActions {
   createStage(stage: any): Promise<boolean>;

   stageExists(stageName: string): Promise<boolean>;

   deleteStage(stageName: string): Promise<boolean>;

   createProject(project: any): Promise<boolean>;

   deleteProject(projectName: string): Promise<boolean>;

   projectExists(projectName: string): Promise<boolean>;

   projectStagesExist(projectName: string): Promise<boolean>;

   createRelease(release: any): Promise<boolean>;

   deleteRelease(releaseName: string): Promise<boolean>;

   /**
    * Открывает страницу средствами роутинга приложения (т.е. без перезагрузки)
    *
    * Перед вызовом нужно убедиться, что хотя бы одна страница открыта.
    */
   pushUrl(path: string): void;
}

interface ClusterConfig {
   title: string;
   value: string;
}

interface AppConfig {
   authorizePath: string;
   avatarHost: string;
   blackboxHost: string;
   clck: string;
   clusters: ClusterConfig[];
   deployEngine: string;
   deployRobots: string[];
   envName: string;
   feedbackFormId: number | null;
   idmSystemName: string;
   nannyUiDomain: string;
   passportHost: string;
   resignPath: string;
   serviceWorkerRefreshIntervalMinutes: number;
   services: {
      name: string;
      endpoint: string;
   }[];
   yasmPush: string;
}

interface Window {
   CONFIG: AppConfig;
   USER: { uid: string; login: string };
   testActions: TestActions;
}

declare namespace Cypress {
   interface Chainable {
      createProject(projectName: string, accountId?: string): Chainable<boolean>;

      // createSimpleStage(stageName: string, project?: string, accountId?: string): Chainable<boolean>;
      createSimpleStage(
         stageName: string,
         options?: { project?: string; accountId?: string; revisionMessage?: string },
      ): Chainable<boolean>;

      createStageWithStatic(stageName: string, project?: string, accountId?: string): Chainable<boolean>;

      deleteProject(projectName: string): Chainable<boolean>;

      deleteStage(stageName: string): Chainable<boolean>;

      stageExists(stageName: string): Chainable<boolean>;

      createRelease(stageName: string, releaseName: string): Chainable<boolean>;

      deleteRelease(releaseName: string): Chainable<boolean>;

      emptyPage(): Chainable;

      envConfig(): Chainable<AppConfig>;

      locationUrl(): Chainable<string>;

      login(login: string, passwd: string): Chainable<void>;

      loginRobot(): Chainable;

      projectExists(projectName: string): Chainable<boolean>;

      projectStagesExist(projectName: string): Chainable<boolean>;

      pushUrl(path: string): Chainable;

      testActions(): Chainable<TestActions>;
   }
}
