import { DEFAULT_ACCOUNT_ID, DEFAULT_PROJECT, STAGE_SPEC_MCRS_CLUSTERS, TIMEOUTS } from '../utils';

Cypress.Commands.add('testActions', () => {
   cy.window().its('testActions', { timeout: TIMEOUTS.slow }).should('not.be.undefined');
   cy.window().then(w => w.testActions);
});

Cypress.Commands.add('pushUrl', (path: string) => {
   cy.testActions()
      .then(actions => actions.pushUrl(path))
      .wait(TIMEOUTS.immediately);
});

// accountId = undefined #DEPLOY-5640
Cypress.Commands.add(
   'createSimpleStage',
   (stageName: string, options?: { project?: string; accountId?: string; revisionMessage?: string }) => {
      cy.fixture('simpleStage.json').then(simpleStage => {
         const { project = DEFAULT_PROJECT, accountId = undefined, revisionMessage } = options ?? {};
         simpleStage.meta.id = stageName;
         simpleStage.meta.project_id = project;

         simpleStage.meta.account_id = accountId; // #DEPLOY-5640

         if (revisionMessage !== undefined) {
            simpleStage.spec.revision_info.description = revisionMessage;
         }

         simpleStage.spec.deploy_units.deployUnit.multi_cluster_replica_set.replica_set.clusters =
            STAGE_SPEC_MCRS_CLUSTERS;

         simpleStage.spec.deploy_units.deployUnit.multi_cluster_replica_set.replica_set.deployment_strategy.max_unavailable =
            STAGE_SPEC_MCRS_CLUSTERS.length - 1;

         cy.testActions().then({ timeout: TIMEOUTS.ypRetries }, actions => actions.createStage(simpleStage));
      });
   },
);

// accountId = undefined #DEPLOY-5640
Cypress.Commands.add('createStageWithStatic', (stageName: string, project = DEFAULT_PROJECT, accountId = undefined) => {
   cy.fixture('stageWithStatic.json').then(simpleStage => {
      simpleStage.meta.id = stageName;
      simpleStage.meta.project_id = project;

      simpleStage.meta.account_id = accountId; // #DEPLOY-5640

      simpleStage.spec.deploy_units.deployUnit.multi_cluster_replica_set.replica_set.clusters =
         STAGE_SPEC_MCRS_CLUSTERS;

      simpleStage.spec.deploy_units.deployUnit.multi_cluster_replica_set.replica_set.deployment_strategy.max_unavailable =
         STAGE_SPEC_MCRS_CLUSTERS.length - 1;

      cy.testActions().then({ timeout: TIMEOUTS.ypRetries }, actions => actions.createStage(simpleStage));
   });
});

Cypress.Commands.add('deleteStage', (stageName: string) => {
   cy.testActions().then({ timeout: TIMEOUTS.ypRetries }, actions => actions.deleteStage(stageName));
});

Cypress.Commands.add('stageExists', (stageName: string) => {
   cy.testActions().then({ timeout: TIMEOUTS.slow }, actions => actions.stageExists(stageName));
});

Cypress.Commands.add('projectStagesExist', (projectName: string) => {
   cy.testActions().then({ timeout: TIMEOUTS.slow }, actions => actions.projectStagesExist(projectName));
});

Cypress.Commands.add('projectExists', (projectName: string) => {
   cy.testActions().then({ timeout: TIMEOUTS.slow }, actions => actions.projectExists(projectName));
});

Cypress.Commands.add('createProject', (projectName = DEFAULT_PROJECT, accountId = DEFAULT_ACCOUNT_ID) => {
   cy.fixture('project.json').then(project => {
      project.meta.id = projectName;
      project.spec.account_id = accountId;

      cy.testActions().then({ timeout: TIMEOUTS.ypRetries }, actions => actions.createProject(project));
   });
});

Cypress.Commands.add('deleteProject', (projectName: string) => {
   cy.testActions().then({ timeout: TIMEOUTS.ypRetries }, actions => actions.deleteProject(projectName));
});

Cypress.Commands.add('createRelease', (stageName: string, releaseName: string) => {
   cy.fixture('release.json').then(release => {
      console.log(release);
      release.meta.id = releaseName;
      release.spec.sandbox.release_author = DEFAULT_ACCOUNT_ID;
      release.spec.sandbox.task_author = DEFAULT_ACCOUNT_ID;

      cy.testActions().then({ timeout: TIMEOUTS.slow }, actions => actions.createRelease(release));
   });
});

Cypress.Commands.add('deleteRelease', (releaseName: string) => {
   cy.testActions().then({ timeout: TIMEOUTS.ypRetries }, actions => actions.deleteRelease(releaseName));
});
