import { TestKeys } from './keys';
export type Selector = string;

export const data = <K extends string, V extends string>(key: K, value: V) => `[data-${key}="${value}"]` as const;

export const dataTest = <K extends TestKeys['data-test']>(testId: K) => data('test', testId);

export const dataE2E = (testId: TestKeys['data-e2e']): Selector => data('e2e', testId);

export const dataQa = (testId: TestKeys['qa']): Selector => data('qa', testId);

export const testCss = (testId: string): Selector => `.test-${testId}`;

export const fieldControl = (labelFor: string, selector: Selector = '> *:first-child'): Selector =>
   `label[for="${labelFor}"] + div ${selector}`;

export const sel = (...parts: string[]): Selector => parts.join(' ');

export const getInputValue = <T = string>(selector: string): Promise<T> =>
   new Promise(resolve => cy.get(selector).then($input => resolve($input.val() as any as T)));

export function alias(alias: string) {
   return `@${alias}`;
}
