# Тесты TESTCAFE

Первая версия тестов для UI Деплоя использует TESTCAFE (новые тесты пишем на CYPRESS).

## Быстрый старт

### Подготовка

Создать файл `.env.local` c настройками:

```sh
# HOST который тестируем
# HOST=https://pre-ui.deploy.yandex-team.ru
# HOST=https://pre2-ui.deploy.yandex-team.ru
# localhost и т.д.
HOST=https://deploy.yandex-team.ru

# Название тестового стейджа (желательно использовать свой логин,
# чтобы не пересекаться со стейджами других пользователей)
STAGE_NAME={your-username}-e2e

# Берём из секретницы
ROBOT_LOGIN={...}
ROBOT_PASSWORD={...}

# SERVICE = frontend | backend
# frontend - более быстрый проход тестов, мы не ждём Ready для всех стейджей
SERVICE=frontend
```

Т.к. у нас очень большие и долгие тесты, то для облегчения ui only тестирования в некоторых тестах есть easy mode, чтобы не гонять их целиком (например, повторное тестирование логов стейджа после смены проекта занимает достаточно много времени, но для ui не несет какой-либо дополнительной пользы). Для этого в файле .env.local нужно добавить флаг service=frontend (значение по умолчанию - "backend").

Логин и пароль робота берём в [секретнице](https://yav.yandex-team.ru/secret/sec-01d7mk270pmfgtqje2y6m23ksx/explore/versions).

### Установка

Установка всех `node_modules`:

```sh
npm i
```

### Запуск

Тесты запускать можно в двух режимах:

1. с открытием браузера ... firefox
2. без открытия браузера ... firefox:headless

Часто удобнее гонять тесты без открытия браузера, но при обнаружении ошибок рекомендуется использовать первый вариант, т.к. из консоли причина падений не всегда бывает очевидна (особенно, если вы тестируете backend, который тоже может падать).

Если нужно прогнать или пропустить отдельные тесты\*, добавляем .only :

1. отдельные тесты - test.only(...
2. группы тестов - fixture.only(...

Аналогично, если нужно пропустить отдельные тесты\*, добавляем .skip :

1. отдельные тесты - test.skip(...
2. группы тестов - fixture.skip(...

\*Не забываем эти изменения откатить перед мерджем других измененний в репозиторий.

Запуск тестов:

```sh
npx testcafe --skip-js-errors --debug-on-fail firefox
npx testcafe --skip-js-errors firefox:headless
```
