const CircularDependencyPlugin = require('circular-dependency-plugin');
const MonacoWebpackPlugin = require('monaco-editor-webpack-plugin');

module.exports = {
   stories: ['../src/**/*.stories.@(tsx|jsx|js)'],
   addons: [
      {
         name: '@storybook/addon-essentials',
         options: {
            backgrounds: false,
            docs: false,
         },
      },
      '@storybook/addon-links',
      '@storybook/addon-knobs',
      '@storybook/preset-create-react-app',
      'storybook-dark-mode',
   ],
   webpack: async config => {
      config.plugins.push(
         new MonacoWebpackPlugin({
            languages: [],
            features: [],
            customLanguages: [
               {
                  label: 'yaml',
                  entry: ['monaco-yaml', 'vs/basic-languages/yaml/yaml.contribution'],
                  worker: {
                     id: 'monaco-yaml/yamlWorker',
                     entry: 'monaco-yaml/yaml.worker',
                  },
               },
            ],
         }),
      );

      config.externals = {
         ...config.externals,
         '@yandex-data-ui/navigation': {},
      };

      if (process.env.CHECK_CIRCULAR === 'true') {
         config.plugins.push(
            new CircularDependencyPlugin({
               // allow import cycles that include an asynchronous import,
               // e.g. via import(/* webpackMode: "weak" */ './file.js')
               allowAsyncCycles: false,
               // set the current working directory for displaying module paths
               cwd: process.cwd(),
               // exclude detection of files based on a RegExp
               exclude: /node_modules/,
               // add errors to webpack instead of warnings
               failOnError: false,
            }),
         );
      }

      return config;
   },
};
