const {
   addExternalBabelPlugin,
   addWebpackExternals,
   addWebpackPlugin,
   adjustWorkbox,
   override,
} = require('customize-cra');
const MonacoWebpackPlugin = require('monaco-editor-webpack-plugin');
const CircularDependencyPlugin = require('circular-dependency-plugin');
const { addMonacoYaml } = require('@yandex-infracloud-ui/monaco-editor/build/cjs/services/addMonacoYaml');

const overrideParts = [
   addWebpackExternals({
      '@yandex-data-ui/navigation': {},
   }),
   addExternalBabelPlugin('@babel/plugin-proposal-class-properties'),
   addWebpackPlugin(
      new MonacoWebpackPlugin({
         languages: [],
         features: [],
         customLanguages: [addMonacoYaml()],
      }),
   ),
   ...(process.env.CHECK_CIRCULAR === 'true'
      ? [
           addWebpackPlugin(
              new CircularDependencyPlugin({
                 // allow import cycles that include an asynchronous import,
                 // e.g. via import(/* webpackMode: "weak" */ './file.js')
                 allowAsyncCycles: false,
                 // set the current working directory for displaying module paths
                 cwd: process.cwd(),
                 // exclude detection of files based on a RegExp
                 exclude: /node_modules/,
                 // add errors to webpack instead of warnings
                 failOnError: false,
              }),
           ),
        ]
      : []),
   adjustWorkbox(wb =>
      Object.assign(wb, {
         dontCacheBustURLsMatching: /(\.[0-9a-f]{8}\.|docs)/,
         exclude: ['index.html'],
         importWorkboxFrom: 'local',
         maximumFileSizeToCacheInBytes: 15 * 1024 * 1024,
         skipWaiting: true,
      }),
   ),
];

module.exports = override(...overrideParts);
