const fetch = require('node-fetch');
const fs = require('fs');
const numeral = require('numeral');
const util = require('util');
const streamPipeline = util.promisify(require('stream').pipeline);

if (!process.env.ROBOT_YP_TOKEN) {
   console.error('------------------------------------------------------------------');
   console.error('You should define ROBOT_YP_TOKEN environment variable before using');
   console.error(
      'You can get this token there: https://yav.yandex-team.ru/secret/sec-01d7mk270pmfgtqje2y6m23ksx/explore/versions',
   );
   console.error('------------------------------------------------------------------\n');
   process.exit(1);
}

const YP_URL = 'https://deploy.yandex-team.ru/api_proxy/yp/ObjectService/SelectObjects';
const REQUEST_BODY = {
   object_type: 'stage',
   selector: { paths: ['/meta', '/labels', '/spec'] },
   options: { limit: 100000 },
};
const ALL_STAGES_FILE = './scripts/all_stages.json';

async function run() {
   console.log('Request all stages');

   const res = await fetch(YP_URL, {
      headers: {
         Accept: 'application/json',
         Authorization: `OAuth ${process.env.ROBOT_YP_TOKEN}`,
         'Content-Type': 'application/json',
      },
      method: 'POST',
      body: JSON.stringify(REQUEST_BODY),
   });

   if (!res.ok) {
      throw new Error(`unexpected response ${res.statusText}`);
   }

   console.log(`Downloading to ${ALL_STAGES_FILE} (${numeral(res.headers.get('content-length')).format('0,0 b')})`);

   await streamPipeline(res.body, fs.createWriteStream(ALL_STAGES_FILE));

   return 'Done';
}

function wait() {
   setTimeout(wait, 1000);
}

run().then(
   r => {
      console.log(r);
      process.exit(0);
   },
   e => {
      console.error(e);
      process.exit(1);
   },
);

wait();
