const fs = require('fs');

const { ReportRenderer } = require('./report_renderer');

class AllStagesReporter {
   async onRunComplete(contexts, results) {
      // fs.writeFileSync('./scripts/testResult.json', JSON.stringify(results, null, 2));
      const renderer = new ReportRenderer(results);

      const html = await renderer.renderHtml();
      fs.writeFileSync('./scripts/all_stages.report.html', html);

      const text = await renderer.renderText();
      fs.writeFileSync('./scripts/all_stages.report.txt', text);

      const md = await renderer.renderMarkdown();
      fs.writeFileSync('./scripts/all_stages.report.md', md);

      const json = await renderer.jsonSummary();
      fs.writeFileSync('./scripts/all_stages.report.summary.json', JSON.stringify(json));

      process.stdout.write(text);
   }
}

module.exports = AllStagesReporter;
