const { readFileSync } = require('fs');
const https = require('https');
const fetch = require('node-fetch');
const summary = require('./all_stages.report.summary.json');

const httpsAgent = new https.Agent({
   rejectUnauthorized: false,
});

class JnsApi {
   constructor() {
      this.baseUrl = 'https://jns.yandex-team.ru/api';
   }

   async request(method, path, body) {
      return fetch(`${this.baseUrl}${path}`, {
         agent: httpsAgent,
         body: JSON.stringify(body),
         headers: {
            'Authorization': `OAuth ${process.env.ROBOT_JNS_TOKEN}`,
            'Content-Type': 'application/json',
         },
         method,
      });
   }

   async sendToChannel(project, channel, params, template = 'default') {
      const body = {
         project,
         template,
         target_project: project,
         channel,
         params,
      };
      console.debug(body);

      return this.request('POST', '/messages/send_to_channel_json', body);
   }
}

const jnsApi = new JnsApi();

async function uploadToS3() {
   console.warn('TODO uploadToS3');
}

async function sendToEmailChannel() {
   const html = readFileSync('./scripts/all_stages.report.html', { encoding: 'utf-8' });

   const resp = await jnsApi.sendToChannel(
      'Deploy',
      'all-stages-test',
      {
         subject: `${summary.ok ? '✅' : '⛔️'} All stages report ${summary.reportDate}`,
         body: html,
      },
      'default_raw',
   );

   const body = await resp.json();

   console.log('Sent to email', { status: resp.status, statusText: resp.statusText, body });
}

async function sendToTelegramChannel() {
   const md = readFileSync('./scripts/all_stages.report.md', { encoding: 'utf-8' });

   const resp = await jnsApi.sendToChannel(
      'Deploy',
      'all-stages-test-failed-only',
      {
         subject: `${summary.ok ? '✅' : '⛔️'} All stages report ${summary.reportDate}`,
         body: md,
      },
      'default_raw',
   );

   const body = await resp.json();

   console.log('Sent to telegram', { status: resp.status, statusText: resp.statusText, body });
}

async function run() {
   await uploadToS3();

   await sendToEmailChannel();

   if (!summary.ok) {
      await sendToTelegramChannel();
   }
}

run().then(
   r => {
      console.log(r);
      process.exit(0);
   },
   e => {
      console.error(e);
      process.exit(1);
   },
);

function wait() {
   setTimeout(wait, 1000);
}

wait();
