const fs = require('fs');

const { ReportRenderer } = require('./report_renderer');

async function run() {
   // eslint-disable-next-line global-require
   const results = require('./testResult.json');
   const renderer = new ReportRenderer(results);

   const html = await renderer.renderHtml();
   fs.writeFileSync('./all_stages.report.html', html);

   const text = await renderer.renderText();
   fs.writeFileSync('./all_stages.report.txt', text);

   const md = await renderer.renderMarkdown();
   fs.writeFileSync('./all_stages.report.md', md);

   const json = await renderer.jsonSummary();
   fs.writeFileSync('./all_stages.report.summary.json', JSON.stringify(json));

   process.stdout.write(md);
}

run().then(
   r => {
      console.log(r);
      process.exit(0);
   },
   e => {
      console.error(e);
      process.exit(1);
   },
);

function wait() {
   setTimeout(wait, 1000);
}

wait();
