/* eslint-disable */
const fs = require('fs');
const glob = require('fast-glob');

const preset = process.env.CONFIG_PRESET || 'ext-local';

const configFile = `../configs/presets/${preset}.json`;
if (fs.existsSync(configFile)) {
   const config = require(`../${configFile}`);
   console.log(JSON.stringify(config, null, 2));
} else {
   const f = glob.sync('../configs/presets/*.json');
   const presets = f.map(presetFile => presetFile.match(/\/([\w-]+?)\.json$/)[1]).join(', ');

   throw new Error('Unknown value in CONFIG_PRESET. Available are: ' + presets);
}
