import { isEqual } from '@yandex-infracloud-ui/libs';
import { AnyFormLevelConfig } from '../components/huge-form';
import { formsFromValue } from '../components/huge-form/hooks/useFormsFromValue';
import { valueFromForms } from '../components/huge-form/hooks/useValueFromForms';
import {
   boxLevelConfig,
   deployUnitLevelConfig,
   stageLevelConfig,
   workloadLevelConfig,
} from '../components/stage-levels';
import { Stage, StageConverter, StagePatcher } from '../models/ui';
import { StagePatcherVisitor } from '../models/ui/stage/StagePatcherVisitor';
import { API } from '../old-code/services/api';
import Notifications from '../old-code/services/Notifications';
import { TStage } from '../proto-typings';
import { configureStore } from '../redux';
import { skipList } from './AllStages.skipList';

// eslint-disable-next-line @typescript-eslint/no-var-requires
const response = require('../../scripts/all_stages.json');

const levelConfigs: AnyFormLevelConfig[] = [
   stageLevelConfig,
   deployUnitLevelConfig,
   boxLevelConfig,
   workloadLevelConfig,
];
const api = new API();
const notifications = new Notifications();
const store = configureStore({ api, notifications });

const whitelist = new Set<string>([]);

const skipped = new Map<string, string>(); // stageId, reason
skipList.forEach((stages, reason) => {
   stages.forEach(stage => {
      skipped.set(stage, reason);
   });
});

const stagesMap = new Map<string, TStage>(
   response.results.map(({ values }: any) => {
      const [meta, labels, spec] = values;
      const stage = { meta, labels, spec };

      return [stage.meta.id, stage];
   }),
);

describe('AllStages tests', () => {
   const visitor = new StagePatcherVisitor({
      options: {
         // updateLogbrokerTools: false,
         enableDynamicResourceUpdater: false,

         // https://st.yandex-team.ru/DEPLOY-5195#6222258537bf95501da1f2d1
         removeDuPatchersAutoupdateRevisionLabel: false,
      },
      duConfirmations: {}, // Явный пустой список "починок"
   });

   function patchStageWithItself(stage: TStage) {
      const model = StageConverter.fromApi(stage);

      const forms = formsFromValue({ value: model, levelConfigs });
      const modelFromForms: Stage = valueFromForms(forms, levelConfigs, store) as any;

      return StagePatcher.patch(visitor, stage, modelFromForms);
   }

   function checkStage(stage: TStage) {
      it(`check stage "${stage.meta!.id}"`, () => {
         expect(patchStageWithItself(stage)).toEqual(stage);
      });
   }

   // fdescribe('Find stages', () => {
   //    stagesMap.forEach(rawStage => {
   //       // const stage = StageConverter.fromApi(rawStage);
   //       if (!isEmpty(rawStage.spec?.dynamic_resources)) {
   //          it(`stage with dynamic resources: ${rawStage.meta!.id}`, () => {});
   //       }
   //    });
   // });

   function skipStage(stageId: string, reason: string) {
      xit(`"${stageId}" because ${reason}`, () => undefined);
   }

   describe('Check all stages from the dump', () => {
      if (whitelist.size > 0) {
         whitelist.forEach(stageId => {
            const stage = stagesMap.get(stageId);

            if (stage) {
               checkStage(stage);
            } else {
               skipStage(stageId, 'not found in all_stages.json');
            }
         });
      } else {
         stagesMap.forEach((stage, stageId) => {
            const reasonToSkip = skipped.get(stageId);
            if (reasonToSkip) {
               skipStage(stageId, reasonToSkip);
            } else {
               checkStage(stage);
            }
         });
      }
   });

   describe('Check skipList actuality', () => {
      skipList.forEach((stages, reason) => {
         describe(`reason: ${reason}`, () => {
            for (const stageId of stages) {
               const stage = stagesMap.get(stageId);
               if (stage) {
                  it(`check broken spec for ${stageId}`, () => {
                     const patched = patchStageWithItself(stage);
                     const result = isEqual(patched, stage);

                     expect(result).toBe(false);
                  });
               } else {
                  skipStage(stageId, 'not found in dump');
               }
            }
         });
      });
   });
});
