import { AnyFormLevelConfig } from '../components/huge-form';
import { formsFromValue } from '../components/huge-form/hooks/useFormsFromValue';
import { valueFromForms } from '../components/huge-form/hooks/useValueFromForms';
import {
   boxLevelConfig,
   deployUnitLevelConfig,
   stageLevelConfig,
   workloadLevelConfig,
} from '../components/stage-levels';
import { DeepPartial } from '../models';
import { Stage, StageConverter, StagePatcher } from '../models/ui';
import { StagePatcherVisitor } from '../models/ui/stage/StagePatcherVisitor';
import { API } from '../old-code/services/api';
import Notifications from '../old-code/services/Notifications';
import { EMultiSecretFileContentFormat, EVolumeMountMode, TStage } from '../proto-typings';
import { configureStore } from '../redux';

const levelConfigs: AnyFormLevelConfig[] = [
   stageLevelConfig,
   deployUnitLevelConfig,
   boxLevelConfig,
   workloadLevelConfig,
];

const visitor = new StagePatcherVisitor({
   options: {
      // updateLogbrokerTools: false,
      enableDynamicResourceUpdater: false,

      // https://st.yandex-team.ru/DEPLOY-5195#6222258537bf95501da1f2d1
      removeDuPatchersAutoupdateRevisionLabel: false,
   },
   duConfirmations: {}, // Явный пустой список "починок"
});

const store = configureStore({ api: new API(), notifications: new Notifications() });

const testStage: DeepPartial<TStage> = {
   meta: {
      account_id: 'abc:service:3285',
      project_id: 'market-mbi',
      id: 'production_market_mbi-api',
   },
   spec: {
      account_id: 'abc:service:3285',
      deploy_units: {
         'mbi-api': {
            box_juggler_configs: {
               infra_box: {
                  archived_checks: [
                     {
                        url: 'https://proxy.sandbox.yandex-team.ru/1971116708',
                     },
                  ],
               },
            },
            dynamic_resource_updater_sandbox_info: {
               revision: 1985693042,
            },
            endpoint_sets: [
               {
                  liveness_limit_ratio: 1.0,
                  port: 80,
               },
            ],
            logbroker_tools_sandbox_info: {
               revision: 2035657882,
            },
            logrotate_configs: {
               infra_box: {
                  run_period_millisecond: 60000,
               },
               'mbi-api_box': {
                  run_period_millisecond: 60000,
               },
            },
            network_defaults: {
               network_id: '_MARKET_PROD_MBI_NETS_',
            },
            pod_agent_sandbox_info: {
               revision: 2051752541,
            },
            replica_set: {
               per_cluster_settings: {
                  sas: {
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                     pod_count: 2,
                  },
                  vla: {
                     deployment_strategy: {
                        max_unavailable: 1,
                     },
                     pod_count: 2,
                  },
               },
               replica_set_template: {
                  constraints: {
                     antiaffinity_constraints: [
                        {
                           key: 'node',
                           max_pods: 2,
                        },
                     ],
                  },
                  pod_template_spec: {
                     labels: {
                        market_abc: 'mbi',
                        market_env: 'production',
                     },
                     spec: {
                        disk_volume_requests: [
                           {
                              id: 'disk-0',
                              labels: {
                                 used_by_infra: true,
                              },
                              quota_policy: {
                                 bandwidth_guarantee: 31457280,
                                 bandwidth_limit: 31457280,
                                 capacity: 49392123904,
                              },
                              storage_class: 'ssd',
                           },
                        ],
                        host_infra: {
                           monitoring: {
                              labels: {
                                 ctype: 'production',
                                 itype: 'marketmbiapi',
                                 prj: 'market',
                              },
                              unistats: [
                                 {
                                    labels: {
                                       itype: 'marketmbiapi',
                                    },
                                    workload_id: 'mbi-api_workload',
                                 },
                                 {
                                    labels: {
                                       itype: 'marketmbiapi',
                                    },
                                    path: '/unistat',
                                    port: 80,
                                    workload_id: 'nginx_workload',
                                 },
                              ],
                           },
                        },
                        pod_agent_payload: {
                           spec: {
                              boxes: [
                                 {
                                    id: 'mbi-api_box',
                                    rootfs: {
                                       layer_refs: [
                                          'layer',
                                          'mbi-api',
                                          'market-sre-binaries',
                                          'market-datasources-production-deploy',
                                       ],
                                    },
                                    static_resources: [
                                       {
                                          mount_point: '/app/secrets',
                                          resource_ref: 'mbi-properties-secrets',
                                       },
                                    ],
                                    volumes: [
                                       {
                                          mode: EVolumeMountMode.EVolumeMountMode_READ_WRITE,
                                          mount_point: '/var/log/yandex',
                                          volume_ref: 'logs_volume',
                                       },
                                       {
                                          mode: EVolumeMountMode.EVolumeMountMode_READ_WRITE,
                                          mount_point: '/app/data',
                                          volume_ref: 'data_volume',
                                       },
                                    ],
                                 },
                                 {
                                    env: [
                                       {
                                          name: 'NGINX_INCLUDES',
                                          value: {
                                             literal_env: {
                                                value: 'include/logging',
                                             },
                                          },
                                       },
                                       {
                                          name: 'PUSH_CLIENT_LOG_FILES',
                                          value: {
                                             literal_env: {
                                                value:
                                                   'nginx/mbi-api-access-tskv.log,mbi-api/mbi-api.log,mbi-api/mbi-api-trace.log',
                                             },
                                          },
                                       },
                                       {
                                          name: 'NGINX_LOG_PREFIX',
                                          value: {
                                             literal_env: {
                                                value: 'mbi-api',
                                             },
                                          },
                                       },
                                    ],
                                    id: 'infra_box',
                                    init: [
                                       {
                                          command_line:
                                             '/usr/local/bin/prostarter /usr/local/bin/dpreparer manifest execute',
                                          time_limit: {
                                             max_execution_time_ms: 60000,
                                          },
                                       },
                                    ],
                                    rootfs: {
                                       layer_refs: [
                                          'layer',
                                          'market-sre-binaries',
                                          'logkeeper',
                                          'solomon-agent',
                                          'push-client',
                                          'market-sre-configs',
                                          'PORTO_LAYER_MARKET_INFRA_DEPLOY_XENIAL',
                                       ],
                                    },
                                    static_resources: [
                                       {
                                          mount_point: '/app/secrets',
                                          resource_ref: 'market-sre-resources-secrets',
                                       },
                                    ],
                                    volumes: [
                                       {
                                          mode: EVolumeMountMode.EVolumeMountMode_READ_WRITE,
                                          mount_point: '/var/log/yandex',
                                          volume_ref: 'logs_volume',
                                       },
                                    ],
                                 },
                              ],
                              mutable_workloads: [
                                 {
                                    workload_ref: 'mbi-api_workload',
                                 },
                                 {
                                    workload_ref: 'nginx_workload',
                                 },
                                 {
                                    workload_ref: 'logkeeper-minion_workload',
                                 },
                                 {
                                    workload_ref: 'push-client_workload',
                                 },
                                 {
                                    workload_ref: 'solomon-agent_workload',
                                 },
                              ],
                              resources: {
                                 layers: [
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'layer',
                                       url: 'sbr:1967086659',
                                    },
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'mbi-api',
                                       url: 'sbr:2212930464',
                                    },
                                    {
                                       checksum: 'MD5:27a917325ff8b09af756126fc73b24af',
                                       id: 'market-sre-configs',
                                       meta: {
                                          sandbox_resource: {
                                             attributes: {
                                                backup_task: '972024922',
                                                branch: 'trunk',
                                                build_type: 'release',
                                                description: 'market-sre-configs.linux.release.trunk.8173047',
                                                platform: 'Linux-4.9.151-35-x86_64-with-Ubuntu-12.04-precise',
                                                released: 'stable',
                                                resource_name: 'market-sre-configs',
                                                resource_version: '8173047',
                                                svn_path: 'arcadia:/arc/trunk/arcadia',
                                                svn_revision: '8173047',
                                                ttl: 'inf',
                                             },
                                             resource_id: '2165327365',
                                             resource_type: 'MARKET_DEPLOY_SRE_CONFIGS',
                                             task_id: '971989302',
                                             task_type: 'YA_PACKAGE',
                                          },
                                       },
                                       url: 'sbr:2165327365',
                                    },
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'logkeeper',
                                       url: 'sbr:1819368301',
                                    },
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'solomon-agent',
                                       url: 'sbr:1935335310',
                                    },
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'PORTO_LAYER_MARKET_INFRA_DEPLOY_XENIAL',
                                       url: 'sbr:2061190130',
                                    },
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'push-client',
                                       url: 'sbr:1872250283',
                                    },
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'market-sre-binaries',
                                       url: 'sbr:2059082546',
                                    },
                                    {
                                       checksum: 'EMPTY:',
                                       id: 'market-datasources-production-deploy',
                                       url: 'sbr:2180764139',
                                    },
                                 ],
                                 static_resources: [
                                    {
                                       files: {
                                          files: [
                                             {
                                                file_name: 'mbi-api-secrets.properties',
                                                multi_secret_data: {
                                                   format:
                                                      EMultiSecretFileContentFormat.EMultiSecretFileContentFormat_JAVA,
                                                   secret_alias:
                                                      'sec-01d7kp9kk01qaczgapf23tg03c:ver-01ezcxtm6b5ef1h0y9sap0x556',
                                                },
                                             },
                                          ],
                                       },
                                       id: 'mbi-properties-secrets',
                                       verification: {
                                          check_period_ms: 180000,
                                          checksum: 'EMPTY:',
                                       },
                                    },
                                    {
                                       files: {
                                          files: [
                                             {
                                                file_name: 'push-client-tvm-secret',
                                                secret_data: {
                                                   alias:
                                                      'sec-01dq7mqadyn9rr9a4va6j4ehzh:ver-01dq7mqamekg5pkpvh7rr9q3jt',
                                                   id: 'client_secret',
                                                },
                                             },
                                          ],
                                       },
                                       id: 'market-sre-resources-secrets',
                                       verification: {
                                          check_period_ms: 180000,
                                          checksum: 'EMPTY:',
                                       },
                                    },
                                 ],
                              },
                              volumes: [
                                 {
                                    generic: {},
                                    id: 'logs_volume',
                                 },
                                 {
                                    generic: {},
                                    id: 'data_volume',
                                 },
                              ],
                              workloads: [
                                 {
                                    box_ref: 'mbi-api_box',
                                    destroy_policy: {
                                       http_get: {
                                          any: true,
                                          path: '/shutdown',
                                          port: 81,
                                          time_limit: {
                                             initial_delay_ms: 2000,
                                             max_restart_period_ms: 60000,
                                             min_restart_period_ms: 1000,
                                          },
                                       },
                                       max_tries: 2,
                                    },
                                    id: 'mbi-api_workload',
                                    readiness_check: {
                                       http_get: {
                                          expected_answer: '0;OK',
                                          path: '/ping',
                                          port: 81,
                                          time_limit: {
                                             initial_delay_ms: 5000,
                                             max_restart_period_ms: 60000,
                                             min_restart_period_ms: 5000,
                                             restart_period_back_off: 2,
                                          },
                                       },
                                    },
                                    start: {
                                       command_line:
                                          '/usr/local/bin/prostarter /app/bin/mbi-api-start.sh --logdir=/var/log/yandex/mbi-api --httpport=81 --debugport=8282 --tmpdir=/app/tmp --datadir=/app/data --extdatadir=/app/data-getter --environment=production --jmx-port=86',
                                    },
                                    stop_policy: {
                                       http_get: {
                                          any: true,
                                          path: '/shutdown',
                                          port: 81,
                                          time_limit: {
                                             initial_delay_ms: 2000,
                                             max_restart_period_ms: 60000,
                                             min_restart_period_ms: 1000,
                                          },
                                       },
                                       max_tries: 2,
                                    },
                                    transmit_logs: true,
                                 },
                                 {
                                    box_ref: 'infra_box',
                                    id: 'nginx_workload',
                                    readiness_check: {
                                       tcp_check: {
                                          port: 80,
                                          time_limit: {
                                             initial_delay_ms: 5000,
                                             max_restart_period_ms: 60000,
                                             min_restart_period_ms: 5000,
                                             restart_period_back_off: 2,
                                          },
                                       },
                                    },
                                    start: {
                                       command_line: 'nginx -c /etc/nginx/nginx.conf',
                                    },
                                    stop_policy: {
                                       max_tries: 2,
                                       unix_signal: {
                                          time_limit: {
                                             initial_delay_ms: 1000,
                                             min_restart_period_ms: 10000,
                                          },
                                       },
                                    },
                                    transmit_logs: true,
                                 },
                                 {
                                    box_ref: 'infra_box',
                                    id: 'logkeeper-minion_workload',
                                    readiness_check: {
                                       container: {
                                          command_line: 'bash -c "ps aux | grep -q \'logkeeper-minion.sh\'"',
                                       },
                                    },
                                    start: {
                                       command_line: '/usr/local/bin/logkeeper-minion.sh',
                                    },
                                    transmit_logs: true,
                                 },
                                 {
                                    box_ref: 'infra_box',
                                    id: 'push-client_workload',
                                    readiness_check: {
                                       container: {
                                          command_line: '/usr/bin/push-client-check.sh',
                                       },
                                    },
                                    start: {
                                       command_line: '/usr/local/bin/prostarter /usr/bin/push-client-start.sh',
                                    },
                                    transmit_logs: true,
                                 },
                                 {
                                    box_ref: 'infra_box',
                                    id: 'solomon-agent_workload',
                                    readiness_check: {
                                       container: {
                                          command_line: '/bin/bash /app/bin/solomon-agent-check.sh',
                                       },
                                    },
                                    start: {
                                       command_line: '/bin/bash /app/bin/solomon-agent-start.sh',
                                    },
                                    transmit_logs: true,
                                 },
                              ],
                           },
                        },
                        resource_requests: {
                           memory_guarantee: 3221225472,
                           memory_limit: 3221225472,
                           vcpu_guarantee: 2000,
                           vcpu_limit: 2000,
                        },
                        secrets: {
                           'sec-01d7kp9kk01qaczgapf23tg03c:ver-01ezcxtm6b5ef1h0y9sap0x556': {
                              secret_id: 'sec-01d7kp9kk01qaczgapf23tg03c',
                              secret_version: 'ver-01ezcxtm6b5ef1h0y9sap0x556',
                           },
                           'sec-01dq7mqadyn9rr9a4va6j4ehzh:ver-01dq7mqamekg5pkpvh7rr9q3jt': {
                              secret_id: 'sec-01dq7mqadyn9rr9a4va6j4ehzh',
                              secret_version: 'ver-01dq7mqamekg5pkpvh7rr9q3jt',
                           },
                        },
                     },
                  },
               },
            },
            revision: 157,
            tvm_config: {},
         },
      },
      revision: 114,
      revision_info: {},
   },
};

function patchStageWithItself(stage: TStage) {
   const model = StageConverter.fromApi(stage);

   const forms = formsFromValue({ value: model, levelConfigs });
   const modelFromForms: Stage = valueFromForms(forms, levelConfigs, store) as any;

   return StagePatcher.patch(visitor, stage, modelFromForms);
}

describe('SingleStageTest', () => {
   it('should not be modified', () => {
      expect(patchStageWithItself(testStage as TStage)).toEqual(testStage);
   });
});
