import { SwitchRoutes } from '@yandex-infracloud-ui/libs';
import React, { useEffect, useState } from 'react';
import { useHistory } from 'react-router';
import { Observable } from 'rxjs';

import { User } from '../../models';
import NotificationsContainer from '../../old-code/components/NotificationsContainer/NotificationsContainer';
import { OldRouteRedirects } from '../../pages/_oldRoutes';
import { ROUTES } from '../../pages/_routes';
import { AppShell } from '../AppShell/AppShell';

interface Props {
   user: User;
   newVersion: Observable<boolean>;
}

export const App: React.FC<Props> = ({ user, newVersion }) => {
   const [newVersionAvailable, setNewVersionAvailable] = useState(false);
   const history = useHistory();

   useEffect(() => {
      const onNewVersion = newVersion.subscribe(value => {
         setNewVersionAvailable(value);
      });

      return () => {
         onNewVersion.unsubscribe();
      };
   }, [newVersion]);

   useEffect(() => {
      if (!window.testActions.pushUrl) {
         window.testActions.pushUrl = (p: string) => history.push(p);
      }
   }, [history]);

   return (
      <AppShell user={user} newVersionAvailable={newVersionAvailable}>
         <OldRouteRedirects />

         <SwitchRoutes>{ROUTES}</SwitchRoutes>

         <NotificationsContainer />
      </AppShell>
   );
};

App.displayName = 'App';
