import { Banner, classNames, ModalContainer, TimedBanner } from '@yandex-infracloud-ui/libs';
import { Pointerfocus } from 'lego-on-react';
import React from 'react';
import { Link } from 'react-router-dom';

import { urlBuilder, User } from '../../models';
import { FooterWrap } from '../FooterWrap/FooterWrap';
import Header from '../Header/Header';

import classes from './AppShell.module.css';

interface Props {
   stickyHeader?: boolean;
   newVersionAvailable?: boolean;
   user: User;
}

export const AppShell: React.FC<Props> = ({ stickyHeader = true, newVersionAvailable = false, user, children }) => (
   <div>
      {newVersionAvailable && (
         <Banner title={'New version available!'} action={'Reload the page'} onAction={() => window.location.reload()}>
            <span>The new version of the web application is ready to use. </span>
            <Link to={urlBuilder.changelog()}>See changelog</Link>
         </Banner>
      )}

      <TimedBanner
         bannerId={'Survey_2021_Q1'}
         endDateISO={'2021-04-01'}
         link={'https://forms.yandex-team.ru/surveys/65359/'}
         title={'Tell us about your experience using Yandex Deploy'}
         action={'Take the survey'}
      />

      <TimedBanner
         bannerId={'BaseInfraSurvey_2021_Q1'}
         endDateISO={'2021-04-01'}
         link={'https://forms.yandex-team.ru/surveys/65903/?target=1'}
         title={'Take the survey about container runtime'}
         action={'Take Base Infra survey'}
      />

      <header className={classNames(classes.header, { [classes.sticky]: stickyHeader })}>
         <Header user={user} />
      </header>

      <main className={classes.content}>{children}</main>

      <FooterWrap />

      <Pointerfocus />

      <ModalContainer />
   </div>
);

AppShell.displayName = 'AppShell';

/*
   <Banner
      buttonText="Complete the survey"
      id="survey1"
      title="Help us to make Y.Deploy better!"
      text="The survey takes only 10 minutes"
      url="https://forms.yandex-team.ru/surveys/25865/"
      endDate={new Date('2019-12-01T00:00:00.000Z')}
   />
 */
