import { Copyright, Footer } from 'lego-on-react';
import React from 'react';

import { EXTERNAL_LINKS, urlBuilder } from '../../models';

import classes from './FooterWrap.module.css';

export const FooterWrap: React.FC = () => (
   <footer className={classes.footerWrap}>
      <Footer region={'en'} tld={'en'}>
         <Footer.Column side={'left'}>
            <Footer.Link theme={'pseudo'} url={urlBuilder.changelog()}>
               Changelog
            </Footer.Link>
         </Footer.Column>
         <Footer.Column side={'right'}>
            <Footer.Link theme={'normal'} url={EXTERNAL_LINKS.wiki.nda} target={'_blank'}>
               NDA
            </Footer.Link>
            <Copyright start={2015}>LLC «Yandex»</Copyright>
         </Footer.Column>
      </Footer>
   </footer>
);

FooterWrap.displayName = 'FooterWrap';
