import { InfraBuzzer } from '@yandex-data-ui/infra-buzzer';
import { ExternalLink, FeedbackButton } from '@yandex-infracloud-ui/libs';
import block from 'bem-cn-lite';
import { User } from 'lego-on-react';
import PropTypes from 'prop-types';
import React from 'react';
import { Link } from 'react-router-dom';

import { EXTERNAL_LINKS, urlBuilder } from '../../models';
import { UISettings, UserSettings } from '../../components';
import NavigationTabs from '../../old-code/components/NavigationTabs/NavigationTabs';
import { Config, ConfigContext } from '../../services';
import { ReactComponent as Cap } from '../Logo/Cap.svg';
import { Logo } from '../Logo/Logo';

import './Header.scss';

const b = block('header');

// TODO port to TS/hooks
export default class Header extends React.Component {
   static propTypes = {
      user: PropTypes.object,
   };

   constructor(props) {
      super(props);

      this.state = {
         offline: !window.navigator.onLine,
      };
   }

   componentDidMount() {
      window.addEventListener('online', this.updateNetworkState);
      window.addEventListener('offline', this.updateNetworkState);
   }

   componentWillUnmount() {
      window.removeEventListener('online', this.updateNetworkState);
      window.removeEventListener('offline', this.updateNetworkState);
   }

   updateNetworkState = () => {
      this.setState({ offline: !window.navigator.onLine });
   };

   renderLogo() {
      const { offline } = this.state;
      const now = new Date();

      // Включить после 15 декабря до конца января
      const isNewYear = (now.getMonth() === 11 && now.getDate() > 15) || now.getMonth() === 0;

      return (
         <div className={b('logo', { offline })} data-test={'logo'}>
            <Link to={urlBuilder.home()} className={b('logo-link')}>
               <div className={b('logo-icon')}>
                  <Logo />
                  {isNewYear && (
                     <div className={b('cap')}>
                        <Cap />
                     </div>
                  )}
                  {offline && <div className={b('offline')}>offline</div>}
               </div>
            </Link>
         </div>
      );
   }

   renderBuzzer() {
      const config = Config.getInfraBuzzerConfig();
      if (!config.enabled) {
         return null;
      }

      return <InfraBuzzer subscribeTo={config.subscribeTo} environment={config.environment} />;
   }

   renderUser() {
      const { user } = this.props;

      return (
         <div className={b('user')}>
            <User
               // нужно передавать undefined, чтобы рисовать кнопку,
               // если пользователь вернулся со страницы через кнопку 'back'
               uid={!user.login ? undefined : user.uid}
               yu={user.uid}
               name={user.displayName || user.login}
               avatarId={user.login}
               avatarHost={'https://center.yandex-team.ru'}
               passportHost={'https://passport.yandex-team.ru'}
               provider={'yandex-team'}
               mix={{ block: b('header-user') }}
            />
         </div>
      );
   }

   renderLinks() {
      return (
         <div className={b('links')} data-test={'support-links'}>
            <ExternalLink
               href={EXTERNAL_LINKS.deployDocs.index}
               grey={true}
               className={b('link')}
               data-test={'support-link-docs'}
            >
               Docs
            </ExternalLink>

            <ExternalLink
               href={'https://t.me/joinchat/Be0kOD50fVxMoi_8hPvG6Q'}
               grey={true}
               className={b('link')}
               data-test={'support-link-telegram'}
            >
               Telegram
            </ExternalLink>

            <ExternalLink
               href={'https://st.yandex-team.ru/rtcsupport/'}
               grey={true}
               className={b('link')}
               data-test={'support-link-st'}
            >
               ST
            </ExternalLink>
         </div>
      );
   }

   renderTabs() {
      const tabs = [
         {
            path: {
               url: urlBuilder.projects(),
               match: [
                  { predicate: '/projects' },
                  { predicate: '/new-stage' },
                  { predicate: '/stages' },
                  { predicate: '/', strict: true },
               ],
            },
            id: 'projects',
            title: 'Projects',
         },
         {
            id: 'balancers',
            title: 'Balancers',
            path: {
               url: urlBuilder.balancers(),
               match: [{ predicate: urlBuilder.balancers(), strict: true }],
            },
         },
         {
            id: 'yp',
            title: 'YP',
            path: {
               url: urlBuilder.yp(),
               match: [{ predicate: urlBuilder.yp() }],
            },
         },
         {
            id: 'quotas',
            title: 'YP Quotas',
            path: {
               url: urlBuilder.ypQuotas(),
               match: [{ predicate: urlBuilder.ypQuotas() }],
            },
         },
      ];

      if (Config.isDeployAdmin()) {
         tabs.push({
            id: 'admin',
            title: 'Admin',
            path: {
               url: urlBuilder.admin(),
               match: [{ predicate: urlBuilder.admin() }],
            },
         });
      }

      return <NavigationTabs tabs={tabs} className={b('tabs')} />;
   }

   renderUserSettings() {
      return <UserSettings />;
   }

   renderUISettings() {
      return (
         <ConfigContext.Consumer>{config => (config.isUIDeveloper() ? <UISettings /> : null)}</ConfigContext.Consumer>
      );
   }

   renderFeedbackButton() {
      return (
         <ConfigContext.Consumer>
            {config =>
               config.feedbackFormId ? (
                  <FeedbackButton
                     cls={b('feedbackFormButton')}
                     formId={config.feedbackFormId}
                     title={'Bug report or feedback for Deploy'}
                  />
               ) : null
            }
         </ConfigContext.Consumer>
      );
   }

   render() {
      return (
         <div className={b()}>
            {this.renderLogo()}
            {this.renderTabs()}
            {this.renderUISettings()}
            {this.renderUserSettings()}
            {this.renderLinks()}
            {this.renderBuzzer()}
            {this.renderFeedbackButton()}
            {this.renderUser()}
         </div>
      );
   }
}

Header.propTypes = {
   user: PropTypes.object,
};
