import { classNames } from '@yandex-infracloud-ui/libs';
import { Modal } from 'lego-on-react';
import * as React from 'react';
import { PropsWithChildren, useEffect, useMemo } from 'react';

import classes from './LegoModal.module.css';

/**
 * Подсмотрел этот код в Twitter Bootstrap 4
 */
function getScrollbarWidth(): number {
   const scrollDiv = document.createElement('div');
   scrollDiv.className = classes.scrollbarMeasure;
   document.body.appendChild(scrollDiv);

   const scrollbarWidth = scrollDiv.getBoundingClientRect().width - scrollDiv.clientWidth;
   document.body.removeChild(scrollDiv);

   return scrollbarWidth;
}

function toggleBodyClass(state: boolean, scrollbarWidth: number) {
   const style: Partial<CSSStyleDeclaration> = state
      ? { overflow: 'hidden', paddingRight: `${scrollbarWidth}px` }
      : { overflow: '', paddingRight: '' };

   Object.assign(document.body.style, style);
}

let openedModalCount = 0;

interface Props {
   className?: string;
   valign?: 'top' | 'center';
   visible: boolean;

   onOutsideClick(): void;
}

/**
 * Обёртка над леговским Modal, в основном для корректной отработки прокрутки (scrollbar)
 *
 * @deprecated use <Dialog> from data-ui/common
 */
export const LegoModal: React.FC<PropsWithChildren<Props>> = React.memo(
   ({ className, visible, onOutsideClick, children, valign = 'top' }) => {
      const scrollbarWidth = useMemo(() => getScrollbarWidth(), []);

      useEffect(() => {
         openedModalCount += 1;

         return () => {
            openedModalCount -= 1;
            if (openedModalCount === 0) {
               toggleBodyClass(false, scrollbarWidth);
            }
         };
      }, [scrollbarWidth]);

      useEffect(() => {
         toggleBodyClass(visible, scrollbarWidth);
      }, [scrollbarWidth, visible]);

      return (
         <Modal
            cls={classNames(className, { [classes.topModal]: valign === 'top' })}
            visible={visible}
            onOutsideClick={onOutsideClick}
         >
            {children}
         </Modal>
      );
   },
);
