import { ControlProps, RadioBoxProps, RadioButton, RadioButtonProps } from 'lego-on-react';
import React, { FC } from 'react';

export type LegoRadioButtonSize = 'm' | 'n' | 's' | 'xs' | 'l';

type FixedRadioButtonProps = Partial<Omit<RadioBoxProps & RadioButtonProps, 'size'>> & { size?: LegoRadioButtonSize };

/**
 * @deprecated  use <RadioButton> from data-ui/common
 */
export const LegoRadioButton: FC<ControlProps & FixedRadioButtonProps> = React.memo(props => (
   <RadioButton theme={'normal'} size={'s' as any} view={'default'} tone={'grey'} freeWidth={true} {...props} />
));

LegoRadioButton.displayName = 'LegoRadioButton';
