import { faCheck, faTimes } from '@fortawesome/free-solid-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { StaffCard } from '@yandex-data-ui/common';

import { formatDate, UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './ApprovalList.module.scss';

interface UserApproval {
   login: string;
   timestamp: Date | null;
   status: 'approved' | 'disapproved';
   comment?: string;
}

interface Props {
   approvals: UserApproval[];
}

export const ApprovalList = React.memo(({ approvals }: Props) => (
   <div>
      {approvals.map(approval => {
         const { login, timestamp, status, comment } = approval;
         const icon = status === 'approved' ? faCheck : faTimes;
         return (
            <div key={`${login}-${timestamp}`} className={classes.block}>
               <div className={classes.header}>
                  <div className={classes.user}>
                     <div className={classes['user-name']}>
                        <StaffCard login={login}>
                           <UserName value={{ id: login, type: UserOrGroupType.People }} />
                        </StaffCard>
                     </div>
                     <div className={`${classes.status} ${classes[`status__${status}`]}`}>
                        <FontAwesomeIcon icon={icon} />
                     </div>
                  </div>
                  <div className={classes.timestamp}>{timestamp && formatDate(timestamp, 'HH:mm, dd MMM yyyy')}</div>
               </div>
               {comment && <div className={classes.comment}>{comment}</div>}
            </div>
         );
      })}
   </div>
));

ApprovalList.displayName = 'ApprovalList';
