import { UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs';
import React, { useCallback } from 'react';
import { useDispatch, useSelector } from 'react-redux';

import { storageMethods } from '../../../old-code/store/reducers';
import type { RootState } from '../../../redux';

interface Props {
   groupId: string;
}

const fetchedGroups: { [key: string]: Date } = {};
const cacheTime = 60 * 60 * 1000; // 1 hour

export const GroupLink: React.FC<Props> = React.memo(({ groupId }: Props) => {
   const dispatch = useDispatch();

   const fetchGroup = useCallback(
      () => dispatch(storageMethods.staff.fetchGroups({ params: { groupIds: [groupId] } })),
      [groupId, dispatch],
   );

   const groups = useSelector((state: RootState) => storageMethods.staff.selectGroups(state));

   if (!(groupId in groups)) {
      if (!(groupId in fetchedGroups) || +new Date() - +fetchedGroups[groupId] > cacheTime) {
         fetchedGroups[groupId] = new Date();
         fetchGroup();
      }
      return <span>{groupId}</span>;
   }

   const group = groups[groupId];

   return (
      <UserName
         value={{
            id: group.url,
            name: group.name,
            type: UserOrGroupType.Group,
         }}
         hideAvatar={true}
      />
   );
});

GroupLink.displayName = 'GroupLink';
