import { Meta } from '@storybook/react';
import * as React from 'react';

import { JsonCustom } from './JsonCustom';

const obj = {
   'empty_object': {},
   'empty_array': [],
   'empty_string': '',
   'string': '0000-00-00T00:00:00.000000Z',
   'number': 0,
   'true': true,
   'false': false,
   'null': null,
   'undefined': undefined,
   'array': ['abc', 123],
   'object': { 'abc': 123 },
   // @nodejsgirl не двигайте это длинное страшное чудовище в начало объекта, его надо долго скроллить, чтобы посмотреть другие поля
   'stack_trace': `org.quartz.SchedulerException: Job threw an unhandled exception.\n\tat org.quartz.core.JobRunShell.run(JobRunShell.java:213)\n\tat org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\n\tCaused by: org.springframework.jdbc.UncategorizedSQLException: jOOQ; uncategorized SQLException for SQL [update clean_cutoff set timestamp = ? where clean_cutoff.type = ?]; SQL state [25P02]; error code [0]; ERROR: current transaction is aborted, commands ignored until end of transaction block; nested exception is org.postgresql.util.PSQLException: ERROR: current transaction is aborted, commands ignored until end of transaction block\n\tat org.jooq_3.10.7.POSTGRES_9_5.debug(Unknown Source)\n\tat org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:84)\n\tat org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:81)\n\tat org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:81)\n\tat ru.yandex.qe.hitman.comrade.domain.jooq.spring.ExceptionTranslator.exception(ExceptionTranslator.java:26)\n\tat org.jooq.impl.ExecuteListeners.exception(ExecuteListeners.java:240)\n\tat org.jooq.impl.AbstractQuery.execute(AbstractQuery.java:362)\n\tat org.jooq.impl.AbstractDelegatingQuery.execute(AbstractDelegatingQuery.java:127)\n\tat ru.yandex.qe.hitman.comrade.domain.repository.impl.DbCleanCutoffRepository.putInterval(DbCleanCutoffRepository.java:48)\n\tat ru.yandex.qe.hitman.comrade.domain.repository.clean.DbCleaner$1.doInTransactionWithoutResult(DbCleaner.java:80)\n\tat org.springframework.transaction.support.TransactionCallbackWithoutResult.doInTransaction(TransactionCallbackWithoutResult.java:34)\n\tat org.springframework.transaction.support.TransactionTemplate.execute(TransactionTemplate.java:133)\n\tat ru.yandex.qe.hitman.comrade.domain.repository.clean.DbCleaner.doClean(DbCleaner.java:62)\n\tat ru.yandex.qe.hitman.comrade.application.quartz.DbCleanJob.execute(DbCleanJob.java:30)\n\tat org.quartz.core.JobRunShell.run(JobRunShell.java:202)\n\t\t... 1 common frames omitted\n\tCaused by: org.postgresql.util.PSQLException: ERROR: current transaction is aborted, commands ignored until end of transaction block\n\tat org.postgresql.core.v3.QueryExecutorImpl.receiveErrorResponse(QueryExecutorImpl.java:2270)\n\tat org.postgresql.core.v3.QueryExecutorImpl.processResults(QueryExecutorImpl.java:1998)\n\tat org.postgresql.core.v3.QueryExecutorImpl.execute(QueryExecutorImpl.java:255)\n\tat org.postgresql.jdbc2.AbstractJdbc2Statement.execute(AbstractJdbc2Statement.java:570)\n\tat org.postgresql.jdbc2.AbstractJdbc2Statement.executeWithFlags(AbstractJdbc2Statement.java:420)\n\tat org.postgresql.jdbc2.AbstractJdbc2Statement.execute(AbstractJdbc2Statement.java:413)\n\tat org.apache.commons.dbcp2.DelegatingPreparedStatement.execute(DelegatingPreparedStatement.java:198)\n\tat org.apache.commons.dbcp2.DelegatingPreparedStatement.execute(DelegatingPreparedStatement.java:198)\n\tat org.jooq.tools.jdbc.DefaultPreparedStatement.execute(DefaultPreparedStatement.java:209)\n\tat org.jooq.impl.AbstractQuery.execute(AbstractQuery.java:429)\n\tat org.jooq.impl.AbstractDMLQuery.execute(AbstractDMLQuery.java:452)\n\tat org.jooq.impl.AbstractQuery.execute(AbstractQuery.java:347)\n\t\t... 9 common frames omitted`,
};

export const ObjectStory = () => <JsonCustom value={obj} />;

export const ArrayStory = () => <JsonCustom value={[obj, obj]} />;

export const StringStory = () => <JsonCustom value={'string'} />;

export const NumberStory = () => <JsonCustom value={1e6} />;

export const NullStory = () => <JsonCustom value={null} />;

export const TrueStory = () => <JsonCustom value={true} />;

export const FalseStory = () => <JsonCustom value={false} />;

export const SortingStory = () => (
   <JsonCustom
      value={{
         z9: '',
         z11: '',
         z1: '',
         a9: '',
         a11: '',
         a1: '',
         9: '',
         11: '',
         1: '',
      }}
   />
);

export const EmptyStory = () => <JsonCustom />;

export default {
   title: 'components/common/JsonCustom',
} as Meta;
