import { formatValue } from './JsonCustom';

describe('format value', () => {
   it('"string"', () => {
      expect(formatValue('string')).toBe('"string"');
   });

   it('""', () => {
      expect(formatValue('')).toBe('""');
   });

   it('1234567890', () => {
      expect(formatValue(1234567890)).toBe('1234567890');
   });

   it('0', () => {
      expect(formatValue(0)).toBe('0');
   });

   it('true', () => {
      expect(formatValue(true)).toBe('true');
   });

   it('false', () => {
      expect(formatValue(false)).toBe('false');
   });

   it('null', () => {
      expect(formatValue(null)).toBe('null');
   });

   it('undefined', () => {
      expect(formatValue(undefined)).toBe('undefined');
   });
});
