import { Rows } from '@yandex-infracloud-ui/libs';
import React from 'react';

import classes from './JsonCustom.module.css';

// не ломать #DEPLOY-3530 #DEPLOY-4929
export const formatValue = (value: string | number | boolean | null | undefined): string => {
   if (typeof value === 'string') {
      // строку выводим всегда в кавычках
      return `"${value}"`;
   }

   // любое другое значение выводим строкой (!)
   return `${value}`;
};

interface CustomValueComponent {
   ({
      field,
      value,
      path,
      children,
   }: {
      field: string;
      value: any;
      path: (string | number)[];
      children?: string | JSX.Element;
   }): JSX.Element;
}

const LevelObject = React.memo(
   ({
      value,
      path,
      customValueComponent,
   }: {
      value: any;
      path: (string | number)[];
      customValueComponent?: CustomValueComponent;
   }) => (
      <>
         {'{'}
         {Object.keys(value).map((key, index) => (
            <div className={classes.level} data-key={key} key={key}>
               <span className={'key'}>{`"${key}"`}</span>
               {': '}
               <JsonLevel
                  field={key}
                  value={value[key]}
                  path={[...path, `${key}`]}
                  customValueComponent={customValueComponent}
               />
               {index !== Object.keys(value).length - 1 ? ',' : null}
            </div>
         ))}
         {'}'}
      </>
   ),
);

const LevelArray = React.memo(
   ({
      values,
      path,
      customValueComponent,
   }: {
      values: any[];
      path: (string | number)[];
      customValueComponent?: CustomValueComponent;
   }) => (
      <>
         [
         {values.map((value: any, index: number) => (
            // eslint-disable-next-line react/no-array-index-key
            <div className={classes.level} key={`key-array-${path}-${index}`}>
               <JsonLevel
                  field={`${index}`}
                  value={value}
                  path={[...path, index]}
                  customValueComponent={customValueComponent}
               />
               {index !== values.length - 1 ? ',' : null}
            </div>
         ))}
         ]
      </>
   ),
);

function JsonValue({
   type,
   field,
   value,
   path,
   customValueComponent,
}: {
   type: string;
   field?: string;
   value: any;
   path: (string | number)[];
   customValueComponent?: CustomValueComponent;
}) {
   const Value = () =>
      typeof value !== 'string' ? (
         <span className={`value ${type}`}>{formatValue(value)}</span>
      ) : (
         <span className={`value ${type} ${classes.pre}`}>
            <Rows text={formatValue(value)} />
         </span>
      );

   if (customValueComponent && field) {
      const ValueComponent = customValueComponent;

      return (
         <ValueComponent field={field} value={value} path={path}>
            <Value />
         </ValueComponent>
      );
   }

   return <Value />;
}

function JsonLevel({
   field,
   value,
   path,
   customValueComponent,
}: {
   field?: string;
   value: any;
   path: (string | number)[];
   customValueComponent?: CustomValueComponent;
}) {
   const type = typeof value;
   if (['number', 'string', 'boolean', 'undefined'].includes(type) || value === null) {
      return (
         <JsonValue type={type} field={field} value={value} path={path} customValueComponent={customValueComponent} />
      );
   }

   if (typeof value === 'object') {
      if (Array.isArray(value)) {
         return <LevelArray values={value} path={path} customValueComponent={customValueComponent} />;
      }

      return <LevelObject value={value} path={path} customValueComponent={customValueComponent} />;
   }

   return null;
}

export const JsonCustom = React.memo(
   ({ value, customValueComponent }: { value?: any; customValueComponent?: CustomValueComponent }) => {
      if (value === undefined) {
         return null;
      }

      return (
         <div className={`${classes.json} jsonCustom`} data-test={'json-custom'}>
            <JsonLevel value={value} path={[]} customValueComponent={customValueComponent} />
         </div>
      );
   },
);

JsonCustom.displayName = 'JsonCustom';
