import React from 'react';

import { JsonCustom } from '../JsonCustom/JsonCustom';
import classes from './LogJson.module.css';

interface CustomValueComponent {
   ({
      field,
      value,
      path,
      children,
   }: {
      field: string;
      value: any;
      path: (string | number)[];
      children?: any;
   }): JSX.Element;
}

interface Props {
   log: Record<string, any>;
   customValueComponent?: CustomValueComponent;
}

export const LogJson: React.FC<Props> = React.memo(({ log, customValueComponent }) => (
   <div className={classes.log}>
      <JsonCustom value={log} customValueComponent={customValueComponent} />
   </div>
));

LogJson.displayName = 'LogJson';
