import { ExternalLink, WarningPlate } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';

const additionalInfo: Record<string, ReactNode> = {
   man: (
      <>
         See <ExternalLink href={'https://clubs.at.yandex-team.ru/infra-cloud/2575'}>post about MAN</ExternalLink>
      </>
   ),
};

interface Props {
   cluster: string;
   isDisabled?: boolean;
}

export const LostClusterWarningPlate: React.FC<Props> = React.memo(({ cluster, isDisabled }) => (
   <WarningPlate theme={'danger'}>
      <h3>
         {cluster.toUpperCase()} {isDisabled ? '' : 'will be'} marked as ready and skipped
      </h3>
      We advise to remove {cluster.toUpperCase()} location from your deploy units settings.
      {additionalInfo.hasOwnProperty(cluster) && (
         <p>
            <br />
            {additionalInfo[cluster]}
         </p>
      )}
   </WarningPlate>
));

LostClusterWarningPlate.displayName = 'LostClusterWarningPlate';
