import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { RoleGroup, rolesData } from '../../../models/roles';
import { useConfig } from '../../../services';

interface Props {
   roleGroup: RoleGroup;
   projectId: string;
   stageId?: string;
   boxType?: string;
}

export const ManageRoleLink: React.FC<Props> = React.memo(({ projectId, stageId, roleGroup, boxType }) => {
   const systemName = useConfig()!.idmSystemName;

   const stagePart = stageId ? `/${stageId}` : '';
   const boxPart = boxType ? `/${boxType}` : '';
   const rolePart = `${systemName}/${projectId}${stagePart}${boxPart}/${rolesData.roles[roleGroup].idmId}`;

   const url = `https://idm.yandex-team.ru/system/${systemName}/roles#f-status=all,f-role=${rolePart},sort-by=-updated,f-is-expanded=true`;

   return <ExternalLink href={url}>Manage Roles</ExternalLink>;
});

ManageRoleLink.displayName = 'ManageRoleLink';
