import { Popover } from '@yandex-cloud/uikit';
import React, { ReactNode, useCallback, useState } from 'react';

import { Storage } from '../../../models/Storage';

const storage = new Storage();

interface Promo {
   storageKey: string; // ключ в localStorage
   title: string;
   message: string;
}

interface Props extends Promo {
   children: ReactNode;
}

export const PromoTooltip: React.FC<Props> = React.memo(({ storageKey, title, message, children }) => {
   const [visible, setVisible] = useState(storage.getItem(storageKey, true));

   const handleOpenToggle = useCallback(() => {
      setVisible(v => !v);
   }, []);

   if (!visible) {
      return <>{children}</>;
   }

   return (
      <Popover
         title={title}
         content={message}
         tooltipActionButton={{
            text: "Don't show me again",
            onClick: e => {
               e.stopPropagation();
               setVisible(false);
               storage.setItem(storageKey, false);
            },
         }}
         initialOpen={visible}
         theme={'special'}
         placement={['bottom']}
         onOpenChange={handleOpenToggle}
      >
         {children}
      </Popover>
   );
});

PromoTooltip.displayName = 'PromoTooltip';
