import { ExternalLink } from '@yandex-infracloud-ui/libs';
import React, { useMemo } from 'react';
import { handleStopPropagation } from '../../../utils';
import { parseTextToObjects, TextParserType } from '../../../utils/parsers/parseTextToObjects';
import { StartrekRenderMode, StartrekTicket } from '../StartrekTicket/StartrekTicket';

export const RichMessage: React.FC<{ text: string }> = ({ text }) => {
   const tokens = useMemo(
      () =>
         parseTextToObjects(text, {
            links: true,
            startrekTicket: true,
            startrekTicketUrl: true,
         }),
      [text],
   );

   return (
      <span>
         {tokens.map(({ text: value, type }) => {
            if (type === TextParserType.STARTREK_TICKET) {
               return <StartrekTicket id={value} lazyLoad={false} mode={StartrekRenderMode.HOVER_TOOLTIP} />;
            }

            if (type === TextParserType.LINK) {
               return (
                  <ExternalLink href={value} onClick={handleStopPropagation}>
                     {value}
                  </ExternalLink>
               );
            }

            return value;
         })}
      </span>
   );
};
