import React, { Fragment, useState } from 'react';

import Link from '../../../old-code/components/Link/Link';
import { GroupLink } from '../GroupLink/GroupLink';
import { ManageRoleLink } from '../ManageRoleLink/ManageRoleLink';
import { UserLink } from '../../lib';
import { RoleGroup } from '../../../models/roles';

import classes from './RolesList.module.scss';

function RoleAccount({ account }: { account: string }) {
   return (
      <span key={account}>
         {account.match(/^group:\d+$/) ? <GroupLink groupId={account.split(':')[1]} /> : <UserLink id={account} />}
      </span>
   );
}

interface Props {
   role: RoleGroup;
   accounts: string[];
   inheritedAccounts: string[];
   projectId: string;
   stageId?: string;
   boxType?: string;
}

export const RolesList: React.FC<Props> = React.memo(
   ({ role, accounts, inheritedAccounts, projectId, stageId, boxType }: Props) => {
      const [opened, setOpened] = useState(false);

      return (
         <div className={classes.list}>
            {inheritedAccounts && inheritedAccounts.length > 0 && (
               <>
                  <Link
                     theme={'pseudo'}
                     onClick={() => setOpened(!opened)}
                     style={{ textDecoration: 'dashed underline', color: 'var(--deploy-color-link)' }}
                  >
                     {inheritedAccounts.length} Inherited
                  </Link>
                  {opened && ':'}
                  {opened &&
                     inheritedAccounts.map(account => (
                        <Fragment key={account}>
                           <RoleAccount account={account} />
                        </Fragment>
                     ))}
                  {accounts.length > 0 && (
                     <>
                        {opened && <br />}
                        <i className={'far fa-plus'} />
                     </>
                  )}
               </>
            )}
            {accounts.map(account => (
               <Fragment key={account}>
                  <RoleAccount account={account} />
               </Fragment>
            ))}
            <ManageRoleLink
               {...{
                  projectId,
                  stageId,
                  boxType,
                  roleGroup: role,
               }}
            />
         </div>
      );
   },
);
RolesList.displayName = 'RolesList';
