import { Skeleton } from '@yandex-cloud/uikit';
import { StaffCard } from '@yandex-data-ui/common';

import { UserName, UserOrGroupType } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { StartrekTicket } from '../../../models/ui';

import classes from './StartrekTicket.module.css';

type Props = {
   ticket: StartrekTicket | null;
};

export const RowTicket: React.FC<Props> = React.memo(({ ticket }) => {
   const { summary, status, user } = ticket ?? {};

   return ticket ? (
      <>
         {status && <span className={classes.startrekStatus}>{status}</span>}
         {summary && <span className={classes.startrekSummary}>{summary}</span>}
         {user && (
            <StaffCard login={user}>
               <UserName value={{ id: user, type: UserOrGroupType.People }} />
            </StaffCard>
         )}
      </>
   ) : (
      <Skeleton className={`${classes.startrekSkeleton} ${classes.skeletonTooltip}`} />
   );
});
