import { Meta } from '@storybook/react';
import React from 'react';
import { startrekLoader, StartrekRenderMode, StartrekTicket } from './StartrekTicket';

const ticket = {
   id: 'DEPLOY-370',
   status: 'Решен',
   summary: 'Отображать количество доступных пользователю вычислительных ресурсов',
   user: 'nikolaichev',
};

const styleRow = {
   display: 'flex',
   alignItems: 'center',
};

const styleTooltip: React.CSSProperties = {
   display: 'flex',
   flexDirection: 'column',
};

startrekLoader.hook = id => (id === ticket.id ? { ticket } : { ticket: null });

const RenderTicket = ({ mode, style }: { mode: StartrekRenderMode; style: React.CSSProperties }) => {
   const WithData = <StartrekTicket style={style} mode={mode} id={ticket.id} />;
   const WithoutData = <StartrekTicket style={style} mode={mode} id={'DEPLOY-375'} />;

   return (
      <>
         <h4>With loaded data</h4>
         <hr />
         {WithData}

         <h4 style={{ marginTop: '100px' }}>Without loaded data</h4>
         <hr />
         {WithoutData}
      </>
   );
};

export const Row = () => <RenderTicket style={styleRow} mode={StartrekRenderMode.ROW} />;
export const OnHover = () => <RenderTicket style={styleTooltip} mode={StartrekRenderMode.HOVER_TOOLTIP} />;

export default {
   title: 'components/lib/StartrekTicket',
} as Meta;
