import React, { ReactNode } from 'react';

import { Label } from '@yandex-cloud/uikit';

import { pluralNumber } from '../../../utils';
import { CopyWrapper } from '../../lib';

import classes from './YpErrorHeader.module.css';

interface Props {
   title: string;
   id: string;
   count: number;
   location?: string;
   size?: 'm' | 's';
}

export const YpErrorHeader: React.FC<Props> = React.memo(
   ({ title, id, count, location, size = 'm', children: PodObjectData }) => {
      const Title = ({ children }: { children: ReactNode }) =>
         size === 'm' ? <h3>{children}</h3> : <h4>{children}</h4>;
      return (
         <div className={classes.header}>
            <Title>
               {title}{' '}
               <CopyWrapper text={id}>
                  <strong>{id}</strong>
               </CopyWrapper>
            </Title>
            {location && (
               <div className={classes.cluster}>
                  <Label>{location}</Label>
               </div>
            )}
            <div className={classes.count}>{pluralNumber(count, 'error', 'errors')}</div>
            {PodObjectData}
         </div>
      );
   },
);

YpErrorHeader.displayName = 'YpErrorHeader';
