import { Meta } from '@storybook/react';
import * as React from 'react';
import { YtError } from './YtError';

const attributes = {
   'string': '0000-00-00T00:00:00.000000Z',
   'empty_string': '',
   'number0': 0,
   'number123': 1234567890,
   'true': true,
   'false': false,
   'null': null,
   'undefined': undefined,
   'array': [],
   'object': {},
};

const error = {
   code: 1,
   message: 'The first error message',
   attributes,
   inner_errors: [
      {
         code: 10,
         message: 'The second error message',
         attributes,
         inner_errors: [
            {
               code: 101,
               message: 'The third error message (long long long long long long long long long)',
               attributes,
            },
         ],
      },
      {
         code: 20,
         message: 'One more error message',
         attributes,
         inner_errors: [
            {
               code: 201,
               message:
                  'One more long error message (long long long long long long long long long long long long long long long long long long long long long long long long long long long)',
               attributes,
            },
         ],
      },
   ],
};

export const Short = () => (
   <YtError
      error={{
         code: 1,
         message: 'The first error message',
         attributes,
      }}
   />
);

export const Long = () => <YtError error={error} />;

export default {
   title: 'components/common/YtError',
} as Meta;
