import { ClipboardButton } from '@yandex-cloud/uikit';
import React from 'react';
import { JsonCustom } from '../JsonCustom/JsonCustom';
import classes from './YtError.module.css';

interface Props {
   error: Record<string, any>;
}

export const YtError: React.FC<Props> = React.memo(({ error }) => (
   <div className={`${classes.error} ytError`} data-test={'yt-error'}>
      <div className={classes.json}>
         <JsonCustom value={error} />
      </div>
      <div className={classes.copyJson}>
         <ClipboardButton text={JSON.stringify(error, null, '  ')} size={16} />
      </div>
   </div>
));

YtError.displayName = 'YtError';
