import { Meta, Story } from '@storybook/react';
import { DevJson } from '@yandex-infracloud-ui/libs';
import * as React from 'react';
import { useState } from 'react';

import { modalsSupportDecorator, routerDecorator } from '../../stories';

import { DeployLogPage } from './DeployLogPage';

const Template: Story<{ initialQueryString: string }> = ({ initialQueryString }) => {
   const [queryString, setQueryString] = useState(initialQueryString);

   return (
      <>
         <DevJson open={true}>{queryString}</DevJson>
         <DeployLogPage
            apiEndpoint={'https://ui-proxy.deploy.yandex-team.ru/api/logs/'}
            projectId={'nodejsgirl'}
            stageId={'nodejsgirl-e2e-logs'}
            deployUnitIds={[
               'DeployUnitJsonLogs',
               'DeployUnitStringLogs',
               'DeployUnitLongLongLongLongLongLongLongLongLongLongLongLogs',
            ]}
            queryString={queryString}
            onQueryStringUpdate={setQueryString}
         />
      </>
   );
};

export const Default = Template.bind({});
Default.args = { initialQueryString: '' };

export default {
   decorators: [modalsSupportDecorator, routerDecorator],
   title: 'components/deploy-log-page/DeployLogPage',
} as Meta;
